/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;

public abstract class AbstractBeanFactory
implements ConfigurableBeanFactory {
    private static final Object CURRENTLY_IN_CREATION = new Object();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private BeanFactory parentBeanFactory;
    private Map customEditors = new HashMap();
    private final List beanPostProcessors = new ArrayList();
    private boolean hasDestructionAwareBeanPostProcessors;
    private final Map aliasMap = Collections.synchronizedMap(new HashMap());
    private final Map singletonCache = Collections.synchronizedMap(new HashMap());
    private final Map disposableBeans = Collections.synchronizedMap(new HashMap());
    private final Map dependentBeanMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public AbstractBeanFactory() {
    }

    public AbstractBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, null, null);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBean(name, requiredType, null);
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        return this.getBean(name, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String name, Class requiredType, Object[] args) throws BeansException {
        String beanName = this.transformedBeanName(name);
        Object bean = null;
        Object sharedInstance = this.singletonCache.get(beanName);
        if (sharedInstance != null) {
            if (sharedInstance == CURRENTLY_IN_CREATION) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning cached instance of singleton bean '" + beanName + "'"));
            }
            bean = this.getObjectForSharedInstance(name, sharedInstance);
        } else {
            RootBeanDefinition mergedBeanDefinition = null;
            try {
                mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
            }
            catch (NoSuchBeanDefinitionException ex) {
                if (this.parentBeanFactory instanceof AbstractBeanFactory) {
                    return ((AbstractBeanFactory)this.parentBeanFactory).getBean(name, requiredType, args);
                }
                if (this.parentBeanFactory != null && args == null) {
                    return this.parentBeanFactory.getBean(name, requiredType);
                }
                throw ex;
            }
            this.checkMergedBeanDefinition(mergedBeanDefinition, beanName, requiredType, args);
            if (mergedBeanDefinition.isSingleton()) {
                Map map = this.singletonCache;
                synchronized (map) {
                    sharedInstance = this.singletonCache.get(beanName);
                    if (sharedInstance == null) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("Creating shared instance of singleton bean '" + beanName + "'"));
                        }
                        this.singletonCache.put(beanName, CURRENTLY_IN_CREATION);
                        try {
                            sharedInstance = this.createBean(beanName, mergedBeanDefinition, args);
                            this.singletonCache.put(beanName, sharedInstance);
                        }
                        catch (BeansException ex) {
                            this.singletonCache.remove(beanName);
                            throw ex;
                        }
                    }
                }
                bean = this.getObjectForSharedInstance(name, sharedInstance);
            } else {
                bean = this.createBean(name, mergedBeanDefinition, args);
            }
        }
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public boolean containsBean(String name) {
        String beanName = this.transformedBeanName(name);
        if (this.singletonCache.containsKey(beanName)) {
            return true;
        }
        if (this.containsBeanDefinition(beanName)) {
            return true;
        }
        if (this.parentBeanFactory != null) {
            return this.parentBeanFactory.containsBean(name);
        }
        return false;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            Class beanClass = null;
            boolean singleton = true;
            Object beanInstance = this.singletonCache.get(beanName);
            if (beanInstance == CURRENTLY_IN_CREATION) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            if (beanInstance != null) {
                beanClass = beanInstance.getClass();
                singleton = true;
            } else {
                RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
                if (bd.hasBeanClass()) {
                    beanClass = bd.getBeanClass();
                }
                singleton = bd.isSingleton();
            }
            if (beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !this.isFactoryDereference(name)) {
                FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
                return factoryBean.isSingleton();
            }
            return singleton;
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.isSingleton(name);
            }
            throw ex;
        }
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            Class beanClass = null;
            Object beanInstance = this.singletonCache.get(beanName);
            if (beanInstance == CURRENTLY_IN_CREATION) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            if (beanInstance != null) {
                beanClass = beanInstance.getClass();
            } else {
                RootBeanDefinition mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
                if (!mergedBeanDefinition.hasBeanClass() || mergedBeanDefinition.getFactoryMethodName() != null) {
                    return null;
                }
                beanClass = mergedBeanDefinition.getBeanClass();
            }
            if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !this.isFactoryDereference(name)) {
                FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
                return factoryBean.getObjectType();
            }
            return beanClass;
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.getType(name);
            }
            throw ex;
        }
        catch (BeanCreationException ex) {
            this.logger.debug((Object)"Ignoring BeanCreationException on FactoryBean type check", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        if (this.singletonCache.containsKey(beanName) || this.containsBeanDefinition(beanName)) {
            ArrayList aliases = new ArrayList();
            Map map = this.aliasMap;
            synchronized (map) {
                Iterator it = this.aliasMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!entry.getValue().equals(beanName)) continue;
                    aliases.add(entry.getKey());
                }
            }
            return aliases.toArray(new String[aliases.size()]);
        }
        if (this.parentBeanFactory != null) {
            return this.parentBeanFactory.getAliases(name);
        }
        throw new NoSuchBeanDefinitionException(beanName, this.toString());
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        Assert.notNull(requiredType, "Required type must not be null");
        Assert.notNull(propertyEditor, "PropertyEditor must not be null");
        this.customEditors.put(requiredType, propertyEditor);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        Assert.notNull(beanPostProcessor, "BeanPostProcessor must not be null");
        this.beanPostProcessors.add(beanPostProcessor);
        if (beanPostProcessor instanceof DestructionAwareBeanPostProcessor) {
            this.hasDestructionAwareBeanPostProcessors = true;
        }
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    protected boolean hasDestructionAwareBeanPostProcessors() {
        return this.hasDestructionAwareBeanPostProcessors;
    }

    protected BeanWrapper createBeanWrapper(Object beanInstance) {
        return beanInstance != null ? new BeanWrapperImpl(beanInstance) : new BeanWrapperImpl();
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        Iterator it = this.customEditors.keySet().iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            bw.registerCustomEditor(clazz, (PropertyEditor)this.customEditors.get(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.hasText(alias, "Alias must not be empty");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering alias '" + alias + "' for bean with name '" + beanName + "'"));
        }
        Map map = this.aliasMap;
        synchronized (map) {
            Object registeredName = this.aliasMap.get(alias);
            if (registeredName != null) {
                throw new BeanDefinitionStoreException("Cannot register alias '" + alias + "' for bean name '" + beanName + "': it's already registered for bean name '" + registeredName + "'");
            }
            this.aliasMap.put(alias, beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSingleton(String beanName, Object singletonObject) throws BeanDefinitionStoreException {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(singletonObject, "Singleton object must not be null");
        Map map = this.singletonCache;
        synchronized (map) {
            Object oldObject = this.singletonCache.get(beanName);
            if (oldObject != null) {
                throw new BeanDefinitionStoreException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there's already object [" + oldObject + " bound");
            }
            this.addSingleton(beanName, singletonObject);
        }
    }

    protected void addSingleton(String beanName, Object singletonObject) {
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(singletonObject, "Singleton object must not be null");
        this.singletonCache.put(beanName, singletonObject);
    }

    protected void removeSingleton(String beanName) {
        Assert.hasText(beanName, "Bean name must not be empty");
        this.singletonCache.remove(beanName);
        this.disposableBeans.remove(beanName);
    }

    public int getSingletonCount() {
        return this.singletonCache.size();
    }

    public String[] getSingletonNames() {
        return this.singletonCache.keySet().toArray(new String[this.singletonCache.size()]);
    }

    public boolean containsSingleton(String beanName) {
        Assert.hasText(beanName, "Bean name must not be empty");
        return this.singletonCache.containsKey(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying singletons in factory {" + this + "}"));
        }
        this.singletonCache.clear();
        Map map = this.disposableBeans;
        synchronized (map) {
            Iterator it = new HashSet(this.disposableBeans.keySet()).iterator();
            while (it.hasNext()) {
                this.destroyDisposableBean((String)it.next());
            }
        }
    }

    protected boolean isFactoryDereference(String name) {
        return BeanFactoryUtils.isFactoryDereference(name);
    }

    protected String transformedBeanName(String name) {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        String canonicalName = (String)this.aliasMap.get(beanName);
        return canonicalName != null ? canonicalName : beanName;
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, boolean includingAncestors) throws BeansException {
        try {
            return this.getMergedBeanDefinition(beanName, this.getBeanDefinition(beanName));
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (includingAncestors && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                return ((AbstractBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(beanName, true);
            }
            throw ex;
        }
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd) throws BeansException {
        if (bd instanceof RootBeanDefinition) {
            return (RootBeanDefinition)bd;
        }
        if (bd instanceof ChildBeanDefinition) {
            ChildBeanDefinition cbd = (ChildBeanDefinition)bd;
            RootBeanDefinition pbd = null;
            if (!beanName.equals(cbd.getParentName())) {
                pbd = this.getMergedBeanDefinition(cbd.getParentName(), true);
            } else if (this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                AbstractBeanFactory parentFactory = (AbstractBeanFactory)this.getParentBeanFactory();
                pbd = parentFactory.getMergedBeanDefinition(cbd.getParentName(), true);
            } else {
                throw new NoSuchBeanDefinitionException(cbd.getParentName(), "Parent name '" + cbd.getParentName() + "' is equal to bean name '" + beanName + "' - cannot be resolved without an AbstractBeanFactory parent");
            }
            RootBeanDefinition rbd = new RootBeanDefinition(pbd);
            rbd.overrideFrom(cbd);
            return rbd;
        }
        throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Definition is neither a RootBeanDefinition nor a ChildBeanDefinition");
    }

    protected void checkMergedBeanDefinition(RootBeanDefinition mergedBeanDefinition, String beanName, Class requiredType, Object[] args) throws BeansException {
        if (mergedBeanDefinition.isAbstract()) {
            throw new BeanIsAbstractException(beanName);
        }
        if (mergedBeanDefinition.hasBeanClass()) {
            Class beanClass = mergedBeanDefinition.getBeanClass();
            if (requiredType != null && mergedBeanDefinition.getFactoryMethodName() == null && !(class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !requiredType.isAssignableFrom(beanClass)) {
                throw new BeanNotOfRequiredTypeException(beanName, requiredType, beanClass);
            }
        }
        if (args != null) {
            if (mergedBeanDefinition.isSingleton()) {
                throw new BeanDefinitionStoreException("Cannot specify arguments in the getBean() method when referring to a singleton bean definition");
            }
            if (mergedBeanDefinition.getFactoryMethodName() == null) {
                throw new BeanDefinitionStoreException("Can only specify arguments in the getBean() method in conjunction with a factory method");
            }
        }
    }

    protected Object getObjectForSharedInstance(String name, Object beanInstance) throws BeansException {
        String beanName = this.transformedBeanName(name);
        if (this.isFactoryDereference(name) && !(beanInstance instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, beanInstance.getClass());
        }
        if (beanInstance instanceof FactoryBean) {
            if (!this.isFactoryDereference(name)) {
                FactoryBean factory = (FactoryBean)beanInstance;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Bean with name '" + beanName + "' is a factory bean"));
                }
                try {
                    beanInstance = factory.getObject();
                }
                catch (Exception ex) {
                    throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
                }
                if (beanInstance == null) {
                    throw new FactoryBeanNotInitializedException(beanName, "FactoryBean returned null object: probably not fully initialized (maybe due to circular bean reference)");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Calling code asked for FactoryBean instance for name '" + beanName + "'"));
            }
        }
        return beanInstance;
    }

    public boolean isFactoryBean(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            Object beanInstance = this.singletonCache.get(beanName);
            if (beanInstance == CURRENTLY_IN_CREATION) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            if (beanInstance != null) {
                return beanInstance instanceof FactoryBean;
            }
            RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
            return bd.hasBeanClass() && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).equals(bd.getBeanClass());
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.parentBeanFactory != null) {
                return this.parentBeanFactory.isSingleton(name);
            }
            throw ex;
        }
    }

    protected void registerDisposableBeanIfNecessary(final String beanName, final Object bean, final RootBeanDefinition mergedBeanDefinition) {
        if (mergedBeanDefinition.isSingleton()) {
            String[] dependsOn;
            boolean hasDestroyMethod;
            final boolean isDisposableBean = bean instanceof DisposableBean;
            boolean bl = hasDestroyMethod = mergedBeanDefinition.getDestroyMethodName() != null;
            if (isDisposableBean || hasDestroyMethod || this.hasDestructionAwareBeanPostProcessors()) {
                int counter = 1;
                String id = beanName;
                while (this.disposableBeans.containsKey(id)) {
                    id = beanName + "#" + ++counter;
                }
                this.registerDisposableBean(id, new DisposableBean(){

                    public void destroy() throws Exception {
                        if (AbstractBeanFactory.this.hasDestructionAwareBeanPostProcessors()) {
                            if (AbstractBeanFactory.this.logger.isDebugEnabled()) {
                                AbstractBeanFactory.this.logger.debug((Object)("Applying DestructionAwareBeanPostProcessors to bean with name '" + beanName + "'"));
                            }
                            for (int i = AbstractBeanFactory.this.getBeanPostProcessors().size() - 1; i >= 0; --i) {
                                Object beanProcessor = AbstractBeanFactory.this.getBeanPostProcessors().get(i);
                                if (!(beanProcessor instanceof DestructionAwareBeanPostProcessor)) continue;
                                ((DestructionAwareBeanPostProcessor)beanProcessor).postProcessBeforeDestruction(bean, beanName);
                            }
                        }
                        if (isDisposableBean) {
                            if (AbstractBeanFactory.this.logger.isDebugEnabled()) {
                                AbstractBeanFactory.this.logger.debug((Object)("Invoking destroy() on bean with name '" + beanName + "'"));
                            }
                            ((DisposableBean)bean).destroy();
                        }
                        if (hasDestroyMethod) {
                            if (AbstractBeanFactory.this.logger.isDebugEnabled()) {
                                AbstractBeanFactory.this.logger.debug((Object)("Invoking custom destroy method on bean with name '" + beanName + "'"));
                            }
                            AbstractBeanFactory.this.invokeCustomDestroyMethod(beanName, bean, mergedBeanDefinition.getDestroyMethodName());
                        }
                    }
                });
            }
            if ((dependsOn = mergedBeanDefinition.getDependsOn()) != null) {
                for (int i = 0; i < dependsOn.length; ++i) {
                    this.registerDependentBean(dependsOn[i], beanName);
                }
            }
        }
    }

    protected void registerDisposableBean(String beanName, DisposableBean bean) {
        this.disposableBeans.put(beanName, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDependentBean(String beanName, String dependentBeanName) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            LinkedList<String> dependencies = (LinkedList<String>)this.dependentBeanMap.get(beanName);
            if (dependencies == null) {
                dependencies = new LinkedList<String>();
                this.dependentBeanMap.put(beanName, dependencies);
            }
            dependencies.add(dependentBeanName);
        }
    }

    private void destroyDisposableBean(String beanName) {
        Object disposableBean = this.disposableBeans.remove(beanName);
        if (disposableBean != null) {
            this.destroyBean(beanName, disposableBean);
        }
    }

    protected void destroyBean(String beanName, Object bean) {
        List dependencies;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving dependent beans for bean '" + beanName + "'"));
        }
        if ((dependencies = (List)this.dependentBeanMap.remove(beanName)) != null) {
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                String dependentBeanName = (String)it.next();
                this.destroyDisposableBean(dependentBeanName);
            }
        }
        if (bean instanceof DisposableBean) {
            try {
                ((DisposableBean)bean).destroy();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Destroy method on bean with name '" + beanName + "' threw an exception"), ex);
            }
        }
    }

    protected void invokeCustomDestroyMethod(String beanName, Object bean, String destroyMethodName) {
        Method destroyMethod = BeanUtils.findDeclaredMethodWithMinimalParameters(bean.getClass(), destroyMethodName);
        if (destroyMethod == null) {
            this.logger.error((Object)("Couldn't find a destroy method named '" + destroyMethodName + "' on bean with name '" + beanName + "'"));
        } else {
            Class<?>[] paramTypes = destroyMethod.getParameterTypes();
            if (paramTypes.length > 1) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has more than one parameter - not supported as destroy method"));
            } else if (paramTypes.length == 1 && !paramTypes[0].equals(Boolean.TYPE)) {
                this.logger.error((Object)("Method '" + destroyMethodName + "' of bean '" + beanName + "' has a non-boolean parameter - not supported as destroy method"));
            } else {
                Object[] args = new Object[paramTypes.length];
                if (paramTypes.length == 1) {
                    args[0] = Boolean.TRUE;
                }
                if (!Modifier.isPublic(destroyMethod.getModifiers())) {
                    destroyMethod.setAccessible(true);
                }
                try {
                    destroyMethod.invoke(bean, args);
                }
                catch (InvocationTargetException ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), ex.getTargetException());
                }
                catch (Throwable ex) {
                    this.logger.error((Object)("Couldn't invoke destroy method '" + destroyMethodName + "' of bean with name '" + beanName + "'"), ex);
                }
            }
        }
    }

    protected abstract boolean containsBeanDefinition(String var1);

    protected abstract BeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract Object createBean(String var1, RootBeanDefinition var2, Object[] var3) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

