/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ControlFlow;
import org.springframework.core.ControlFlowFactory;
import org.springframework.core.OrderComparator;

public abstract class AbstractAdvisorAutoProxyCreator
extends AbstractAutoProxyCreator {
    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.findCandidateAdvisors();
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Object bean, String name, TargetSource targetSource) {
        List advisors = this.findEligibleAdvisors(bean.getClass());
        if (advisors.isEmpty()) {
            return DO_NOT_PROXY;
        }
        advisors = this.sortAdvisors(advisors);
        return advisors.toArray();
    }

    protected List findEligibleAdvisors(Class clazz) {
        List candidateAdvisors = this.findCandidateAdvisors();
        LinkedList<Advisor> eligibleAdvisors = new LinkedList<Advisor>();
        for (int i = 0; i < candidateAdvisors.size(); ++i) {
            Advisor candidate = (Advisor)candidateAdvisors.get(i);
            if (AopUtils.canApply(candidate, clazz)) {
                eligibleAdvisors.add(candidate);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Candidate advisor [" + candidate + "] accepted for class [" + clazz.getName() + "]"));
                continue;
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Candidate advisor [" + candidate + "] rejected for class [" + clazz.getName() + "]"));
        }
        return eligibleAdvisors;
    }

    protected List sortAdvisors(List advisors) {
        Collections.sort(advisors, new OrderComparator());
        return advisors;
    }

    protected boolean shouldSkip(Object bean, String name) {
        ControlFlow cflow = ControlFlowFactory.createControlFlow();
        return cflow.under(this.getClass(), "findCandidateAdvisors");
    }

    protected abstract List findCandidateAdvisors();
}

