/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.util.WebUtils;

public class CookieLocaleResolver
implements LocaleResolver {
    public static final String LOCALE_REQUEST_ATTRIBUTE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    public static final String DEFAULT_COOKIE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    public static final String DEFAULT_COOKIE_PATH = "/";
    public static final int DEFAULT_COOKIE_MAX_AGE = Integer.MAX_VALUE;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String cookieName = DEFAULT_COOKIE_NAME;
    private String cookiePath = "/";
    private int cookieMaxAge = Integer.MAX_VALUE;
    static /* synthetic */ Class class$org$springframework$web$servlet$i18n$CookieLocaleResolver;

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
        if (locale != null) {
            return locale;
        }
        Cookie cookie = WebUtils.getCookie(request, this.getCookieName());
        if (cookie != null) {
            locale = StringUtils.parseLocaleString(cookie.getValue());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'"));
            }
            if (locale != null) {
                request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
                return locale;
            }
        }
        return request.getLocale();
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        Cookie cookie = null;
        if (locale != null) {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
            cookie = new Cookie(this.getCookieName(), locale.toString());
            cookie.setPath(this.getCookiePath());
            cookie.setMaxAge(this.getCookieMaxAge());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Set cookie for locale '" + locale + "'"));
            }
        } else {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)request.getLocale());
            cookie = new Cookie(this.getCookieName(), "");
            cookie.setPath(this.getCookiePath());
            cookie.setMaxAge(0);
            this.logger.debug((Object)"Removed locale cookie");
        }
        response.addCookie(cookie);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

