/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.HttpServletBean;

public class ResourceServlet
extends HttpServletBean {
    public static final String RESOURCE_URL_DELIMITERS = ",; \t\n";
    public static final String RESOURCE_PARAM_NAME = "resource";
    private String defaultUrl;
    private String allowedResources;
    private String contentType;
    private boolean applyLastModified = false;
    private long startupTime;

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public void setAllowedResources(String allowedResources) {
        this.allowedResources = allowedResources;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setApplyLastModified(boolean applyLastModified) {
        this.applyLastModified = applyLastModified;
    }

    protected void initServletBean() {
        this.startupTime = System.currentTimeMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceUrl = this.determineResourceUrl(request);
        if (resourceUrl != null) {
            try {
                this.doInclude(request, response, resourceUrl);
                return;
            }
            catch (ServletException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Failed to include content of resource [" + resourceUrl + "]"), (Throwable)ex);
                }
                if (this.includeDefaultUrl(request, response)) return;
                throw ex;
            }
            catch (IOException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Failed to include content of resource [" + resourceUrl + "]"), (Throwable)ex);
                }
                if (this.includeDefaultUrl(request, response)) return;
                throw ex;
            }
        } else {
            if (this.includeDefaultUrl(request, response)) return;
            throw new ServletException("No target resource URL found for request");
        }
    }

    protected String determineResourceUrl(HttpServletRequest request) {
        return request.getParameter(RESOURCE_PARAM_NAME);
    }

    private boolean includeDefaultUrl(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.defaultUrl == null) {
            return false;
        }
        this.doInclude(request, response, this.defaultUrl);
        return true;
    }

    private void doInclude(HttpServletRequest request, HttpServletResponse response, String resourceUrl) throws ServletException, IOException {
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        String[] resourceUrls = StringUtils.tokenizeToStringArray(resourceUrl, RESOURCE_URL_DELIMITERS);
        for (int i = 0; i < resourceUrls.length; ++i) {
            if (this.allowedResources != null && !PathMatcher.match(this.allowedResources, resourceUrls[i])) {
                throw new ServletException("Resource [" + resourceUrls[i] + "] does not match allowed pattern [" + this.allowedResources + "]");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including resource [" + resourceUrls[i] + "]"));
            }
            RequestDispatcher rd = request.getRequestDispatcher(resourceUrls[i]);
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected final long getLastModified(HttpServletRequest request) {
        if (this.applyLastModified) {
            String resourceUrl = this.determineResourceUrl(request);
            if (resourceUrl == null) {
                resourceUrl = this.defaultUrl;
            }
            if (resourceUrl != null) {
                String[] resourceUrls = StringUtils.tokenizeToStringArray(resourceUrl, RESOURCE_URL_DELIMITERS);
                long latestTimestamp = -1L;
                for (int i = 0; i < resourceUrls.length; ++i) {
                    long timestamp = this.getFileTimestamp(resourceUrls[i]);
                    if (timestamp <= latestTimestamp) continue;
                    latestTimestamp = timestamp;
                }
                return latestTimestamp > this.startupTime ? latestTimestamp : this.startupTime;
            }
        }
        return -1L;
    }

    protected long getFileTimestamp(String resourceUrl) {
        try {
            File resource = new ServletContextResource(this.getServletContext(), resourceUrl).getFile();
            long lastModifiedTime = resource.lastModified();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Last-modified timestamp of resource file [" + resource.getAbsolutePath() + "] is [" + lastModifiedTime + "]"));
            }
            return lastModifiedTime;
        }
        catch (IOException ex) {
            this.logger.warn((Object)("Couldn't retrieve lastModified timestamp of resource [" + resourceUrl + "] - returning ResourceServlet startup time"));
            return -1L;
        }
    }
}

