/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class WebSphereNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_ADAPTER_CONNECTION_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection";
    private static final String JDBC_ADAPTER_UTIL_NAME_5 = "com.ibm.ws.rsadapter.jdbc.WSJdbcUtil";
    private static final String CONNECTION_PROXY_NAME_4 = "com.ibm.ejs.cm.proxy.ConnectionProxy";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class webSphereConnectionClass;
    private Method getNativeConnectionMethod;
    private boolean webSphere5;

    public WebSphereNativeJdbcExtractor() throws InvalidDataAccessApiUsageException {
        try {
            this.logger.debug((Object)"Trying WebSphere 5: com.ibm.ws.rsadapter.jdbc.WSJdbcConnection");
            this.webSphereConnectionClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_CONNECTION_NAME_5);
            Class<?> jdbcAdapterUtilClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_UTIL_NAME_5);
            this.getNativeConnectionMethod = jdbcAdapterUtilClass.getMethod("getNativeConnection", this.webSphereConnectionClass);
            this.webSphere5 = true;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Could not find WebSphere 5 connection pool classes", (Throwable)ex);
            try {
                this.logger.debug((Object)"Trying WebSphere 4: com.ibm.ejs.cm.proxy.ConnectionProxy");
                this.webSphereConnectionClass = this.getClass().getClassLoader().loadClass(CONNECTION_PROXY_NAME_4);
                this.getNativeConnectionMethod = this.webSphereConnectionClass.getMethod("getPhysicalConnection", null);
                this.webSphere5 = false;
            }
            catch (Exception ex2) {
                this.logger.debug((Object)"Could not find WebSphere 4 connection pool classes", (Throwable)ex2);
                throw new InvalidDataAccessApiUsageException("Could neither find WebSphere 5 nor WebSphere 4 connection pool classes");
            }
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.webSphereConnectionClass.isAssignableFrom(con.getClass())) {
            try {
                if (this.webSphere5) {
                    return (Connection)this.getNativeConnectionMethod.invoke(null, con);
                }
                return (Connection)this.getNativeConnectionMethod.invoke((Object)con, (Object[])null);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not invoke WebSphere's getNativeConnection method", ex);
            }
        }
        return con;
    }
}

