/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map beans = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public void addBean(String name, Object bean) {
        this.beans.put(name, bean);
    }

    public Object getBean(String name) throws BeansException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (BeanFactoryUtils.isFactoryDereference(name) && !(bean instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, bean.getClass());
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
            try {
                return ((FactoryBean)bean).getObject();
            }
            catch (Exception ex) {
                throw new BeanCreationException("FactoryBean threw exception on object creation", ex);
            }
        }
        return bean;
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.getBean(name);
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name);
        if (bean instanceof FactoryBean) {
            return ((FactoryBean)bean).isSingleton();
        }
        return true;
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name)) {
            return ((FactoryBean)bean).getObjectType();
        }
        return bean.getClass();
    }

    public String[] getAliases(String name) {
        return new String[0];
    }

    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    public String[] getBeanDefinitionNames() {
        Set keySet = this.beans.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public String[] getBeanDefinitionNames(Class type) {
        ArrayList<String> matches = new ArrayList<String>();
        Set keys = this.beans.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Class<?> clazz = this.beans.get(name).getClass();
            if (!type.isAssignableFrom(clazz)) continue;
            matches.add(name);
        }
        return matches.toArray(new String[matches.size()]);
    }

    public boolean containsBeanDefinition(String name) {
        return this.beans.containsKey(name);
    }

    public Map getBeansOfType(Class type) {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        HashMap<String, Object> matches = new HashMap<String, Object>();
        boolean isFactoryType = type != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = StaticListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(type);
        Iterator it = this.beans.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String beanName = (String)entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                Object createdObject;
                FactoryBean factory;
                Class objectType;
                if (!includeFactoryBeans || ((objectType = (factory = (FactoryBean)beanInstance).getObjectType()) != null || !factory.isSingleton()) && (!includePrototypes && !factory.isSingleton() || objectType == null || !type.isAssignableFrom(objectType)) || !type.isInstance(createdObject = this.getBean(beanName))) continue;
                matches.put(beanName, createdObject);
                continue;
            }
            if (!type.isInstance(beanInstance)) continue;
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            matches.put(beanName, beanInstance);
        }
        return matches;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

