/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.MetaDataAccessException;

public class JdbcUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$support$JdbcUtils == null ? (class$org$springframework$jdbc$support$JdbcUtils = JdbcUtils.class$("org.springframework.jdbc.support.JdbcUtils")) : class$org$springframework$jdbc$support$JdbcUtils));
    static /* synthetic */ Class class$org$springframework$jdbc$support$JdbcUtils;

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.warn((Object)"Could not close JDBC Statement", (Throwable)ex);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.warn((Object)"Could not close JDBC ResultSet", (Throwable)ex);
            }
        }
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, DatabaseMetaDataCallback action) throws MetaDataAccessException {
        Connection con = null;
        try {
            con = DataSourceUtils.getConnection(dataSource);
            if (con != null) {
                Object object = action.processMetaData(con.getMetaData());
                return object;
            }
            try {
                throw new MetaDataAccessException("Error while getting connection");
            }
            catch (CannotGetJdbcConnectionException ex) {
                throw new MetaDataAccessException("Error while getting connection", ex);
            }
            catch (DataAccessException ex) {
                throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
            }
            catch (SQLException ex) {
                throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
            }
        }
        finally {
            DataSourceUtils.closeConnectionIfNecessary(con, dataSource);
        }
    }

    public static int countParameterPlaceholders(String str, char placeholder, char delim) {
        return JdbcUtils.countParameterPlaceholders(str, placeholder, "" + delim);
    }

    public static int countParameterPlaceholders(String str, char placeholder, String delimiters) {
        int count = 0;
        boolean insideLiteral = false;
        int activeLiteral = -1;
        for (int i = 0; str != null && i < str.length(); ++i) {
            if (str.charAt(i) == placeholder) {
                if (insideLiteral) continue;
                ++count;
                continue;
            }
            if (delimiters.indexOf(str.charAt(i)) <= -1) continue;
            if (!insideLiteral) {
                insideLiteral = true;
                activeLiteral = delimiters.indexOf(str.charAt(i));
                continue;
            }
            if (activeLiteral != delimiters.indexOf(str.charAt(i))) continue;
            insideLiteral = false;
            activeLiteral = -1;
        }
        return count;
    }

    public static boolean isNumeric(int sqlType) {
        return -7 == sqlType || -5 == sqlType || 3 == sqlType || 8 == sqlType || 6 == sqlType || 4 == sqlType || 2 == sqlType || 7 == sqlType || 5 == sqlType || -6 == sqlType;
    }

    public static int translateType(int sqlType) {
        int retType = sqlType;
        if (-7 == sqlType || -6 == sqlType || 5 == sqlType || 4 == sqlType) {
            retType = 4;
        } else if (1 == sqlType || 12 == sqlType) {
            retType = 12;
        } else if (3 == sqlType || 8 == sqlType || 6 == sqlType || 2 == sqlType || 7 == sqlType) {
            retType = 2;
        }
        return retType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

