/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Method;
import org.springframework.util.StringUtils;

public abstract class ClassUtils {
    private static Class[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final char INNER_CLASS_SEPARATOR_CHAR = '$';

    public static Class forName(String name) throws ClassNotFoundException {
        if (name.length() <= 8) {
            for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
                Class clazz = PRIMITIVE_CLASSES[i];
                if (!clazz.getName().equals(name)) continue;
                return clazz;
            }
        }
        return Class.forName(name);
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(clazz.getName());
    }

    public static String getShortNameAsProperty(Class clazz) {
        return StringUtils.uncapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getShortName(String className) {
        char[] charArray = className.toCharArray();
        int lastDot = 0;
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '.') {
                lastDot = i + 1;
                continue;
            }
            if (charArray[i] != '$') continue;
            charArray[i] = 46;
        }
        return new String(charArray, lastDot, charArray.length - lastDot);
    }

    public static Method getStaticMethod(Class clazz, String methodName, Class[] args) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, args);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static String addResourcePathToPackagePath(Class clazz, String resourceName) {
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }
}

