/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class TransactionAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private TransactionAttributeSource transactionAttributeSource;

    public TransactionAttributeSourceAdvisor(TransactionInterceptor ti) {
        super((Advice)ti);
        if (ti.getTransactionAttributeSource() == null) {
            throw new AopConfigException("Cannot construct a TransactionAttributeSourceAdvisor using a TransactionInterceptor that has no TransactionAttributeSource configured");
        }
        this.transactionAttributeSource = ti.getTransactionAttributeSource();
    }

    public boolean matches(Method m, Class targetClass) {
        return this.transactionAttributeSource.getTransactionAttribute(m, targetClass) != null;
    }
}

