/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class JBossNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String WRAPPED_CONNECTION_NAME = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    private static final String WRAPPED_STATEMENT_NAME = "org.jboss.resource.adapter.jdbc.WrappedStatement";
    private static final String WRAPPED_RESULT_SET_NAME = "org.jboss.resource.adapter.jdbc.WrappedResultSet";
    private Class wrappedConnectionClass = this.getClass().getClassLoader().loadClass("org.jboss.resource.adapter.jdbc.WrappedConnection");
    private Class wrappedStatementClass = this.getClass().getClassLoader().loadClass("org.jboss.resource.adapter.jdbc.WrappedStatement");
    private Method getUnderlyingConnectionMethod = this.wrappedConnectionClass.getMethod("getUnderlyingConnection", null);
    private Method getUnderlyingStatementMethod = this.wrappedStatementClass.getMethod("getUnderlyingStatement", null);

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.wrappedConnectionClass.isAssignableFrom(con.getClass())) {
            try {
                return (Connection)this.getUnderlyingConnectionMethod.invoke((Object)con, null);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not invoke JBoss' getUnderlyingConnection method", ex);
            }
        }
        return con;
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        if (this.wrappedStatementClass.isAssignableFrom(stmt.getClass())) {
            try {
                return (Statement)this.getUnderlyingStatementMethod.invoke((Object)stmt, null);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not invoke JBoss' getUnderlyingStatement method", ex);
            }
        }
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        return (PreparedStatement)this.getNativeStatement(ps);
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        return (CallableStatement)this.getNativeStatement(cs);
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        if (rs.getClass().getName().equals(WRAPPED_RESULT_SET_NAME)) {
            try {
                Method getUnderlyingResultSetMethod = rs.getClass().getMethod("getUnderlyingResultSet", null);
                return (ResultSet)getUnderlyingResultSetMethod.invoke((Object)rs, null);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not invoke JBoss' getUnderlyingResultSet method", ex);
            }
        }
        return rs;
    }
}

