/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;

public class ClassEditor
extends PropertyEditorSupport {
    public static final String ARRAY_SUFFIX = "[]";

    public void setAsText(String text) throws IllegalArgumentException {
        Class<?> clazz = null;
        try {
            if (text.endsWith(ARRAY_SUFFIX)) {
                String elementClassName = text.substring(0, text.length() - ARRAY_SUFFIX.length());
                Class<?> elementClass = Class.forName(elementClassName, true, Thread.currentThread().getContextClassLoader());
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                clazz = Class.forName(text, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid class name: " + ex.getMessage());
        }
        this.setValue(clazz);
    }

    public String getAsText() {
        Class clazz = (Class)this.getValue();
        return clazz.isArray() ? clazz.getComponentType().getName() + ARRAY_SUFFIX : clazz.getName();
    }
}

