/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodOverrides;

public abstract class AbstractBeanDefinition
implements BeanDefinition {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    public static final int AUTOWIRE_CONSTRUCTOR = 3;
    public static final int AUTOWIRE_AUTODETECT = 4;
    public static final int DEPENDENCY_CHECK_NONE = 0;
    public static final int DEPENDENCY_CHECK_OBJECTS = 1;
    public static final int DEPENDENCY_CHECK_SIMPLE = 2;
    public static final int DEPENDENCY_CHECK_ALL = 3;
    private Object beanClass;
    private ConstructorArgumentValues constructorArgumentValues;
    private MutablePropertyValues propertyValues;
    private MethodOverrides methodOverrides = new MethodOverrides();
    private String initMethodName;
    private String destroyMethodName;
    private String staticFactoryMethodName;
    private int autowireMode = 0;
    private int dependencyCheck = 0;
    private String[] dependsOn;
    private boolean singleton = true;
    private boolean lazyInit = false;
    private String resourceDescription;

    protected AbstractBeanDefinition() {
        this.setConstructorArgumentValues(new ConstructorArgumentValues());
        this.setPropertyValues(new MutablePropertyValues());
    }

    protected AbstractBeanDefinition(AbstractBeanDefinition other) {
        this.beanClass = other.beanClass;
        this.setConstructorArgumentValues(new ConstructorArgumentValues(other.getConstructorArgumentValues()));
        this.setPropertyValues(new MutablePropertyValues(other.getPropertyValues()));
        this.setMethodOverrides(new MethodOverrides(other.getMethodOverrides()));
        this.setInitMethodName(other.getInitMethodName());
        this.setDestroyMethodName(other.getDestroyMethodName());
        this.setStaticFactoryMethodName(other.getStaticFactoryMethodName());
        this.setDependsOn(other.getDependsOn());
        this.setAutowireMode(other.getAutowireMode());
        this.setDependencyCheck(other.getDependencyCheck());
        this.setSingleton(other.isSingleton());
        this.setLazyInit(other.isLazyInit());
        this.setResourceDescription(other.getResourceDescription());
    }

    public void overrideFrom(AbstractBeanDefinition other) {
        if (other.beanClass != null) {
            this.beanClass = other.beanClass;
        }
        this.getConstructorArgumentValues().addArgumentValues(other.getConstructorArgumentValues());
        this.getPropertyValues().addPropertyValues(other.getPropertyValues());
        this.getMethodOverrides().addOverrides(other.getMethodOverrides());
        if (other.getInitMethodName() != null) {
            this.setInitMethodName(other.getInitMethodName());
        }
        if (other.getDestroyMethodName() != null) {
            this.setDestroyMethodName(other.getDestroyMethodName());
        }
        if (other.getStaticFactoryMethodName() != null) {
            this.setStaticFactoryMethodName(other.getStaticFactoryMethodName());
        }
        this.setDependsOn(other.getDependsOn());
        this.setAutowireMode(other.getAutowireMode());
        this.setDependencyCheck(other.getDependencyCheck());
        this.setSingleton(other.isSingleton());
        this.setLazyInit(other.isLazyInit());
        this.setResourceDescription(other.getResourceDescription());
    }

    public boolean hasBeanClass() {
        return this.beanClass instanceof Class;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public Class getBeanClass() throws IllegalStateException {
        if (!(this.beanClass instanceof Class)) {
            throw new IllegalStateException("Bean definition does not carry a resolved bean class");
        }
        return (Class)this.beanClass;
    }

    public void setBeanClassName(String beanClassName) {
        this.beanClass = beanClassName;
    }

    public String getBeanClassName() {
        if (this.beanClass instanceof Class) {
            return ((Class)this.beanClass).getName();
        }
        return (String)this.beanClass;
    }

    public void setConstructorArgumentValues(ConstructorArgumentValues constructorArgumentValues) {
        this.constructorArgumentValues = constructorArgumentValues != null ? constructorArgumentValues : new ConstructorArgumentValues();
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.constructorArgumentValues;
    }

    public boolean hasConstructorArgumentValues() {
        return this.constructorArgumentValues != null && !this.constructorArgumentValues.isEmpty();
    }

    public void setPropertyValues(MutablePropertyValues propertyValues) {
        this.propertyValues = propertyValues != null ? propertyValues : new MutablePropertyValues();
    }

    public MutablePropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public void setMethodOverrides(MethodOverrides methodOverrides) {
        this.methodOverrides = methodOverrides != null ? methodOverrides : new MethodOverrides();
    }

    public MethodOverrides getMethodOverrides() {
        return this.methodOverrides;
    }

    public void setInitMethodName(String initMethodName) {
        this.initMethodName = initMethodName;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setDestroyMethodName(String destroyMethodName) {
        this.destroyMethodName = destroyMethodName;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void setStaticFactoryMethodName(String staticFactoryMethodName) {
        this.staticFactoryMethodName = staticFactoryMethodName;
    }

    public String getStaticFactoryMethodName() {
        return this.staticFactoryMethodName;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public int getResolvedAutowireMode() {
        if (this.autowireMode == 4) {
            Constructor<?>[] constructors = this.getBeanClass().getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length != 0) continue;
                return 2;
            }
            return 3;
        }
        return this.autowireMode;
    }

    public void setDependencyCheck(int dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public int getDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependsOn(String[] dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void validate() throws BeanDefinitionValidationException {
        if (this.lazyInit && !this.singleton) {
            throw new BeanDefinitionValidationException("Lazy initialization is applicable only to singleton beans");
        }
        if (!this.getMethodOverrides().isEmpty() && this.getStaticFactoryMethodName() != null) {
            throw new BeanDefinitionValidationException("Cannot combine static factory method with method overrides: the static factory method must create the instance");
        }
        if (this.hasBeanClass()) {
            Class beanClass = this.getBeanClass();
            Iterator itr = this.getMethodOverrides().getOverrides().iterator();
            while (itr.hasNext()) {
                MethodOverride mo = (MethodOverride)itr.next();
                this.validateMethodOverride(mo, beanClass);
            }
        }
    }

    private void validateMethodOverride(MethodOverride mo, Class beanClass) throws BeanDefinitionValidationException {
        if (!BeanUtils.isAtLeastOneMethodWithName(mo.getMethodName(), beanClass)) {
            throw new BeanDefinitionValidationException("No method with name '" + mo.getMethodName() + "' on class " + beanClass.getName() + " specified in lookup override");
        }
    }
}

