/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private boolean lazyInitHandlers = false;
    private Map handlerMap = new HashMap();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws BeansException {
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        this.logger.debug((Object)("Looking up handler for [" + lookupPath + "]"));
        return this.lookupHandler(lookupPath);
    }

    protected Object lookupHandler(String urlPath) throws BeansException {
        Object handler = this.handlerMap.get(urlPath);
        if (handler == null) {
            Iterator it = this.handlerMap.keySet().iterator();
            while (it.hasNext()) {
                String registeredPath = (String)it.next();
                if (!PathMatcher.match(registeredPath, urlPath)) continue;
                handler = this.handlerMap.get(registeredPath);
            }
        }
        return handler;
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException {
        Object mappedHandler = this.handlerMap.get(urlPath);
        if (mappedHandler != null) {
            throw new ApplicationContextException("Cannot map handler [" + handler + "] to URL path [" + urlPath + "]: there's already handler [" + mappedHandler + "] mapped");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                handler = this.getApplicationContext().getBean(handlerName);
            }
        }
        if (urlPath.equals("/*")) {
            this.setDefaultHandler(handler);
        } else {
            this.handlerMap.put(urlPath, handler);
            this.logger.info((Object)("Mapped URL path [" + urlPath + "] onto handler [" + handler + "]"));
        }
    }
}

