/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.io.File;
import javax.servlet.ServletContext;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.WebUtils;

public class ServletEndpointSupport
implements ServiceLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ServletEndpointContext servletEndpointContext;
    private WebApplicationContext webApplicationContext;
    private MessageSourceAccessor messageSourceAccessor;

    public final void init(Object context) throws ServiceException {
        if (!(context instanceof ServletEndpointContext)) {
            throw new ServiceException("ServletEndpointSupport needs ServletEndpointContext, not [" + context + "]");
        }
        this.servletEndpointContext = (ServletEndpointContext)context;
        ServletContext servletContext = this.servletEndpointContext.getServletContext();
        this.webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext);
        this.messageSourceAccessor = new MessageSourceAccessor(this.webApplicationContext);
        this.onInit();
    }

    protected final ServletEndpointContext getServletEndpointContext() {
        return this.servletEndpointContext;
    }

    protected final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected final MessageSourceAccessor getMessageSourceAccessor() {
        return this.messageSourceAccessor;
    }

    protected final ServletContext getServletContext() {
        return this.webApplicationContext.getServletContext();
    }

    protected File getTempDir() {
        return WebUtils.getTempDir(this.getServletContext());
    }

    protected void onInit() {
    }

    public void destroy() {
    }
}

