/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.type.Type;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateOperations;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTemplate
extends HibernateAccessor
implements HibernateOperations {
    private boolean allowCreate = true;

    public HibernateTemplate() {
    }

    public HibernateTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public HibernateTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public Object execute(HibernateCallback action) throws DataAccessException {
        Session session = !this.allowCreate ? SessionFactoryUtils.getSession(this.getSessionFactory(), false) : SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
        boolean existingTransaction = TransactionSynchronizationManager.hasResource(this.getSessionFactory());
        if (!existingTransaction && this.getFlushMode() == 0) {
            session.setFlushMode(FlushMode.NEVER);
        }
        try {
            Object result = action.doInHibernate(session);
            this.flushIfNecessary(session, existingTransaction);
            Object object = result;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
        }
    }

    public List executeFind(HibernateCallback action) throws DataAccessException {
        return (List)this.execute(action);
    }

    public Object get(final Class entityClass, final Serializable id) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(entityClass, id);
            }
        });
    }

    public Object get(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(entityClass, id, lockMode);
            }
        });
    }

    public Object load(final Class entityClass, final Serializable id) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.load(entityClass, id);
            }
        });
    }

    public Object load(final Class entityClass, final Serializable id, final LockMode lockMode) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.load(entityClass, id, lockMode);
            }
        });
    }

    public List loadAll(final Class entityClass) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateTemplate.this.createCriteria(session, entityClass);
                return criteria.list();
            }
        });
    }

    public void evict(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.evict(entity);
                return null;
            }
        });
    }

    public void lock(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entity, lockMode);
                return null;
            }
        });
    }

    public Serializable save(final Object entity) throws DataAccessException {
        return (Serializable)this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.save(entity);
            }
        });
    }

    public void save(final Object entity, final Serializable id) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.save(entity, id);
                return null;
            }
        });
    }

    public void saveOrUpdate(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.saveOrUpdate(entity);
                return null;
            }
        });
    }

    public Object saveOrUpdateCopy(final Object entity) throws DataAccessException {
        return this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.saveOrUpdateCopy(entity);
            }
        });
    }

    public void update(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.update(entity);
                return null;
            }
        });
    }

    public void update(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.update(entity);
                session.lock(entity, lockMode);
                return null;
            }
        });
    }

    public void delete(final Object entity) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.delete(entity);
                return null;
            }
        });
    }

    public void delete(final Object entity, final LockMode lockMode) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.lock(entity, lockMode);
                session.delete(entity);
                return null;
            }
        });
    }

    public void deleteAll(final Collection entities) throws DataAccessException {
        this.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    session.delete(it.next());
                }
                return null;
            }
        });
    }

    public List find(final String queryString) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                return queryObject.list();
            }
        });
    }

    public List find(final String queryString, final Object value) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                queryObject.setParameter(0, value);
                return queryObject.list();
            }
        });
    }

    public List find(final String queryString, final Object value, final Type type) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                queryObject.setParameter(0, value, type);
                return queryObject.list();
            }
        });
    }

    public List find(final String queryString, final Object[] values) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    queryObject.setParameter(i, value);
                }
                return queryObject.list();
            }
        });
    }

    public List find(final String queryString, final Object[] values, final Type[] types) throws DataAccessException {
        if (values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    queryObject.setParameter(i, value, types[i]);
                }
                return queryObject.list();
            }
        });
    }

    public List findByValueBean(final String queryString, final Object valueBean) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.createQuery(session, queryString);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final Object value) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                queryObject.setParameter(0, value);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final Object value, final Type type) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                queryObject.setParameter(0, value, type);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final Object[] values) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    queryObject.setParameter(i, value);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final Object[] values, final Type[] types) throws DataAccessException {
        if (values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    queryObject.setParameter(i, value, types[i]);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final String paramName, final Object value) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                queryObject.setParameter(paramName, value);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final String paramName, final Object value, final Type type) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                queryObject.setParameter(paramName, value, type);
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final String[] paramNames, final Object[] values) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of parmNames array must match length of values array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    queryObject.setParameter(paramNames[i], value);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedQuery(final String queryName, final String[] paramNames, final Object[] values, final Type[] types) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of parmNames array must match length of values array");
        }
        if (values.length != types.length) {
            throw new IllegalArgumentException("Length of values array must match length of types array");
        }
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                for (int i = 0; i < values.length; ++i) {
                    Object value = values[i];
                    queryObject.setParameter(paramNames[i], value, types[i]);
                }
                return queryObject.list();
            }
        });
    }

    public List findByNamedQueryAndValueBean(final String queryName, final Object valueBean) throws DataAccessException {
        return this.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = HibernateTemplate.this.getNamedQuery(session, queryName);
                queryObject.setProperties(valueBean);
                return queryObject.list();
            }
        });
    }

    public Query createQuery(Session session, String queryString) throws HibernateException {
        Query queryObject = session.createQuery(queryString);
        SessionFactoryUtils.applyTransactionTimeout(queryObject, this.getSessionFactory());
        return queryObject;
    }

    public Query getNamedQuery(Session session, String queryName) throws HibernateException {
        Query queryObject = session.getNamedQuery(queryName);
        SessionFactoryUtils.applyTransactionTimeout(queryObject, this.getSessionFactory());
        return queryObject;
    }

    public Criteria createCriteria(Session session, Class entityClass) throws HibernateException {
        Criteria criteria = session.createCriteria(entityClass);
        SessionFactoryUtils.applyTransactionTimeout(criteria, this.getSessionFactory());
        return criteria;
    }
}

