/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi.support;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class SimpleNamingContext
implements Context {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String root;
    private Hashtable boundObjects;
    private Hashtable environment = new Hashtable();

    public SimpleNamingContext() {
        this("");
    }

    public SimpleNamingContext(String root) {
        this.root = root;
        this.boundObjects = new Hashtable();
    }

    public SimpleNamingContext(String root, Hashtable boundObjects, Hashtable environment) {
        this.root = root;
        this.boundObjects = boundObjects;
        if (environment != null) {
            this.environment.putAll(environment);
        }
    }

    public NamingEnumeration list(String root) throws NamingException {
        this.logger.info((Object)("Listing name/class pairs under [" + root + "]"));
        return new NameClassPairEnumeration(this, root);
    }

    public NamingEnumeration listBindings(String root) throws NamingException {
        this.logger.info((Object)("Listing bindings under [" + root + "]"));
        return new BindingEnumeration(this, root);
    }

    public Object lookup(String pname) throws NameNotFoundException {
        String name = this.root + pname;
        this.logger.info((Object)("Static JNDI lookup: [" + name + "]"));
        if ("".equals(name)) {
            return new SimpleNamingContext(this.root, this.boundObjects, this.environment);
        }
        Object found = this.boundObjects.get(name);
        if (found == null) {
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            Iterator it = this.boundObjects.keySet().iterator();
            while (it.hasNext()) {
                String boundName = (String)it.next();
                if (!boundName.startsWith(name)) continue;
                return new SimpleNamingContext(name, this.boundObjects, this.environment);
            }
            throw new NameNotFoundException("Name [" + this.root + pname + "] not bound: " + this.boundObjects.size() + " bindings -- [" + StringUtils.collectionToDelimitedString(this.boundObjects.keySet(), ",") + "]");
        }
        return found;
    }

    public Object lookupLink(String name) throws NameNotFoundException {
        return this.lookup(name);
    }

    public void bind(String name, Object obj) {
        this.logger.info((Object)("Static JNDI binding: [" + this.root + name + "] = [" + obj + "]"));
        this.boundObjects.put(this.root + name, obj);
    }

    public void unbind(String name) {
        this.logger.info((Object)("Static JNDI remove: [" + this.root + name + "]"));
        this.boundObjects.remove(this.root + name);
    }

    public void rebind(String name, Object obj) {
        this.bind(name, obj);
    }

    public void rename(String oldName, String newName) throws NameNotFoundException {
        Object obj = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, obj);
    }

    public Context createSubcontext(String name) {
        SimpleNamingContext subcontext = new SimpleNamingContext(this.root + name, this.boundObjects, this.environment);
        this.bind(name, (Object)subcontext);
        return subcontext;
    }

    public void destroySubcontext(String name) {
        this.unbind(name);
    }

    public Hashtable getEnvironment() {
        return this.environment;
    }

    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    public void close() {
    }

    public NamingEnumeration list(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration listBindings(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public Object lookup(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public Object lookupLink(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public void bind(Name arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    public void unbind(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public void rebind(Name arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    public void rename(Name arg0, Name arg1) {
        throw new UnsupportedOperationException();
    }

    public Context createSubcontext(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public void destroySubcontext(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public String getNameInNamespace() {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(Name arg0) {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Name composeName(Name arg0, Name arg1) {
        throw new UnsupportedOperationException();
    }

    public String composeName(String arg0, String arg1) {
        throw new UnsupportedOperationException();
    }

    private static class BindingEnumeration
    extends AbstractNamingEnumeration {
        private BindingEnumeration(SimpleNamingContext context, String root) throws NamingException {
            super(context, root);
        }

        protected Object createObject(String strippedName, Object obj) {
            return new Binding(strippedName, obj);
        }
    }

    private static class NameClassPairEnumeration
    extends AbstractNamingEnumeration {
        private NameClassPairEnumeration(SimpleNamingContext context, String root) throws NamingException {
            super(context, root);
        }

        protected Object createObject(String strippedName, Object obj) {
            return new NameClassPair(strippedName, obj.getClass().getName());
        }
    }

    private static abstract class AbstractNamingEnumeration
    implements NamingEnumeration {
        private Iterator iterator;

        private AbstractNamingEnumeration(SimpleNamingContext context, String proot) throws NamingException {
            if (!"".equals(proot) && !proot.endsWith("/")) {
                proot = proot + "/";
            }
            String root = context.root + proot;
            HashMap<String, Object> contents = new HashMap<String, Object>();
            Iterator it = context.boundObjects.keySet().iterator();
            while (it.hasNext()) {
                int startIndex;
                int endIndex;
                String strippedName;
                String boundName = (String)it.next();
                if (!boundName.startsWith(root) || contents.containsKey(strippedName = (endIndex = boundName.indexOf(47, startIndex = root.length())) != -1 ? boundName.substring(startIndex, endIndex) : boundName.substring(startIndex))) continue;
                try {
                    contents.put(strippedName, this.createObject(strippedName, context.lookup(proot + strippedName)));
                }
                catch (NameNotFoundException ex) {}
            }
            if (contents.size() == 0) {
                throw new NamingException("Invalid root: [" + context.root + proot + "]");
            }
            this.iterator = contents.values().iterator();
        }

        protected abstract Object createObject(String var1, Object var2);

        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }

        public void close() {
        }
    }
}

