/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.SqlCall;

public abstract class StoredProcedure
extends SqlCall {
    protected StoredProcedure() {
    }

    protected StoredProcedure(DataSource ds, String name) {
        this.setDataSource(ds);
        this.setSql(name);
    }

    protected StoredProcedure(JdbcTemplate jdbcTemplate, String name) {
        this.setJdbcTemplate(jdbcTemplate);
        this.setSql(name);
    }

    public void declareParameter(SqlParameter p) throws InvalidDataAccessApiUsageException {
        if (p.getName() == null) {
            throw new InvalidDataAccessApiUsageException("Parameters to stored procedures must have names as well as types");
        }
        super.declareParameter(p);
    }

    public Map execute(Map inParams) throws InvalidDataAccessApiUsageException {
        this.validateParameters(inParams.values().toArray());
        this.logger.debug((Object)("Executing call: " + this.getCallString()));
        Map retValues = this.getJdbcTemplate().call(this.newCallableStatementCreator(inParams), this.getDeclaredParameters());
        return retValues;
    }

    public Map execute(ParameterMapper inParamMapper) throws InvalidDataAccessApiUsageException {
        this.logger.debug((Object)("Executing call using ParameterMapper: " + this.getCallString()));
        Map retValues = this.getJdbcTemplate().call(this.newCallableStatementCreator(inParamMapper), this.getDeclaredParameters());
        return retValues;
    }
}

