/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class OpenSessionInViewInterceptor
extends HibernateAccessor
implements HandlerInterceptor {
    public OpenSessionInViewInterceptor() {
        this.setFlushMode(0);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws DataAccessException {
        this.logger.debug((Object)"Opening Hibernate Session in OpenSessionInViewInterceptor");
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
        if (this.getFlushMode() == 0) {
            session.setFlushMode(FlushMode.NEVER);
        }
        TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws DataAccessException {
        this.logger.debug((Object)"Flushing Hibernate Session in OpenSessionInViewInterceptor");
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getSessionFactory());
        try {
            this.flushIfNecessary(sessionHolder.getSession(), false);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws DataAccessException {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        this.logger.debug((Object)"Closing Hibernate Session in OpenSessionInViewInterceptor");
        SessionFactoryUtils.closeSessionIfNecessary(sessionHolder.getSession(), this.getSessionFactory());
    }
}

