/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;

public abstract class AbstractJndiLocator
implements InitializingBean {
    public static String CONTAINER_PREFIX = "java:comp/env/";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private String jndiName;
    private boolean inContainer = true;

    public AbstractJndiLocator() {
    }

    public AbstractJndiLocator(String jndiName) throws NamingException, IllegalArgumentException {
        this.setJndiName(jndiName);
        this.afterPropertiesSet();
    }

    public final void setJndiTemplate(JndiTemplate template) {
        this.jndiTemplate = template;
    }

    public final JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public final void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public final String getJndiName() {
        return this.jndiName;
    }

    public void setInContainer(boolean inContainer) {
        this.inContainer = inContainer;
    }

    public final boolean isInContainer() {
        return this.inContainer;
    }

    public final void afterPropertiesSet() throws NamingException, IllegalArgumentException {
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new IllegalArgumentException("Property 'jndiName' must be set on " + this.getClass().getName());
        }
        if (this.inContainer && !this.jndiName.startsWith(CONTAINER_PREFIX) && this.jndiName.indexOf(58) == -1) {
            this.jndiName = CONTAINER_PREFIX + this.jndiName;
        }
        Object o = this.lookup(this.jndiName);
        this.located(o);
    }

    private Object lookup(String jndiName) throws NamingException {
        Object o = this.jndiTemplate.lookup(jndiName);
        this.logger.debug((Object)("Successfully looked up object with jndiName '" + jndiName + "': value=[" + o + "]"));
        return o;
    }

    protected abstract void located(Object var1);
}

