/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.springframework.aop.TargetSource;

public final class SingletonTargetSource
implements TargetSource {
    private Object target;

    public SingletonTargetSource(Object target) {
        this.target = target;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public Object getTarget() {
        return this.target;
    }

    public void releaseTarget(Object o) {
    }

    public String toString() {
        return "Singleton target source (not dynamic): target=[" + this.target + "]";
    }

    public boolean isStatic() {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingletonTargetSource)) {
            return false;
        }
        SingletonTargetSource b = (SingletonTargetSource)other;
        if (this.target == null) {
            return b.target == null;
        }
        return this.target.equals(b.target);
    }
}

