/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.beans.PropertyEditor;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.springframework.context.NoSuchMessageException;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.tags.BindStatus;
import org.springframework.web.servlet.tags.RequestContextAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;

public class BindTag
extends RequestContextAwareTag {
    public static final String STATUS_VARIABLE_NAME = "status";
    private String path;
    private String property;
    private Errors errors;
    private PropertyEditor editor;

    public void setPath(String path) throws JspException {
        this.path = ExpressionEvaluationUtils.evaluateString("path", path, this.pageContext);
    }

    public String getProperty() {
        return this.property;
    }

    public String getPath() {
        return this.path;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public PropertyEditor getEditor() {
        return this.editor;
    }

    protected int doStartTagInternal() throws Exception {
        String name = null;
        this.property = null;
        int dotPos = this.path.indexOf(46);
        if (dotPos == -1) {
            name = this.path;
        } else {
            name = this.path.substring(0, dotPos);
            this.property = this.path.substring(dotPos + 1);
        }
        this.errors = this.getRequestContext().getErrors(name, false);
        if (this.errors == null) {
            throw new JspTagException("Could not find Errors instance for bean '" + name + "' in request");
        }
        List fes = null;
        Object value = null;
        if (this.property != null) {
            if ("*".equals(this.property)) {
                fes = this.errors.getAllErrors();
            } else {
                fes = this.errors.getFieldErrors(this.property);
                value = this.errors.getFieldValue(this.property);
                if (this.errors instanceof BindException) {
                    this.editor = ((BindException)this.errors).getCustomEditor(this.property);
                } else {
                    this.logger.warn((Object)("Cannot not expose custom property editor because Errors instance [" + this.errors + "] is not of type BindException"));
                }
                if (this.isHtmlEscape() && value instanceof String) {
                    value = HtmlUtils.htmlEscape((String)value);
                }
            }
        } else {
            fes = this.errors.getGlobalErrors();
        }
        BindStatus status = new BindStatus(this.property, value, this.getErrorCodes(fes), this.getErrorMessages(fes));
        this.pageContext.setAttribute(STATUS_VARIABLE_NAME, (Object)status);
        return 1;
    }

    private String[] getErrorCodes(List fes) {
        String[] codes = new String[fes.size()];
        for (int i = 0; i < fes.size(); ++i) {
            ObjectError error = (ObjectError)fes.get(i);
            codes[i] = error.getCode();
        }
        return codes;
    }

    private String[] getErrorMessages(List fes) throws NoSuchMessageException {
        String[] messages = new String[fes.size()];
        for (int i = 0; i < fes.size(); ++i) {
            ObjectError error = (ObjectError)fes.get(i);
            messages[i] = this.getRequestContext().getMessage(error, this.isHtmlEscape());
        }
        return messages;
    }

    public void release() {
        super.release();
        this.path = null;
        this.errors = null;
        this.property = null;
    }
}

