/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import org.springframework.util.StringUtils;

public class BindStatus {
    private final String expression;
    private final Object value;
    private final String[] errorCodes;
    private final String[] errorMessages;

    protected BindStatus(String expression, Object value, String[] errorCodes, String[] errorMessages) {
        this.expression = expression;
        this.value = value;
        this.errorCodes = errorCodes;
        this.errorMessages = errorMessages;
    }

    public String getExpression() {
        return this.expression;
    }

    public Object getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return this.value != null ? this.value.toString() : "";
    }

    public boolean isError() {
        return this.errorCodes != null && this.errorCodes.length > 0;
    }

    public String[] getErrorCodes() {
        return this.errorCodes != null ? this.errorCodes : new String[]{};
    }

    public String getErrorCode() {
        return this.errorCodes != null && this.errorCodes.length > 0 ? this.errorCodes[0] : "";
    }

    public String[] getErrorMessages() {
        return this.errorMessages != null ? this.errorMessages : new String[]{};
    }

    public String getErrorMessage() {
        return this.errorMessages != null && this.errorMessages.length > 0 ? this.errorMessages[0] : "";
    }

    public String getErrorMessagesAsString(String delimiter) {
        if (this.errorMessages == null) {
            return "";
        }
        return StringUtils.arrayToDelimitedString(this.errorMessages, delimiter);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BindStatus: value=[" + this.value + "]");
        if (this.isError()) {
            sb.append("; error codes='" + this.errorCodes + "'; error messages='" + this.errorMessages + "'; ");
        }
        sb.append("source=" + (this.isError() ? "error" : "bean"));
        return sb.toString();
    }
}

