/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.support.WebContentGenerator;

public abstract class AbstractController
extends WebContentGenerator
implements Controller {
    private boolean synchronizeOnSession = false;

    public final void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.checkAndPrepare(request, response, this instanceof LastModified);
        HttpSession session = request.getSession(false);
        if (this.synchronizeOnSession && session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                return this.handleRequestInternal(request, response);
            }
        }
        return this.handleRequestInternal(request, response);
    }

    protected abstract ModelAndView handleRequestInternal(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

