/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.config.ConfigurableApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.RequestHandledEvent;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HttpServletBean;
import org.springframework.web.util.WebUtils;

public abstract class FrameworkServlet
extends HttpServletBean {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$springframework$web$context$support$XmlWebApplicationContext == null ? (class$org$springframework$web$context$support$XmlWebApplicationContext = FrameworkServlet.class$("org.springframework.web.context.support.XmlWebApplicationContext")) : class$org$springframework$web$context$support$XmlWebApplicationContext;
    public static final String SERVLET_CONTEXT_PREFIX = (class$org$springframework$web$servlet$FrameworkServlet == null ? (class$org$springframework$web$servlet$FrameworkServlet = FrameworkServlet.class$("org.springframework.web.servlet.FrameworkServlet")) : class$org$springframework$web$servlet$FrameworkServlet).getName() + ".CONTEXT.";
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private boolean publishContext = true;
    private WebApplicationContext webApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$support$XmlWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$servlet$FrameworkServlet;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;

    public final void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace != null ? this.namespace : this.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public final void setPublishContext(boolean publishContext) {
        this.publishContext = publishContext;
    }

    public boolean isPublishContext() {
        return this.publishContext;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    public final String getServletContextAttributeName() {
        return SERVLET_CONTEXT_PREFIX + this.getServletName();
    }

    protected final void initServletBean() throws ServletException, BeansException {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("Framework servlet '" + this.getServletName() + "' init"));
        try {
            this.webApplicationContext = this.initWebApplicationContext();
            this.initFrameworkServlet();
        }
        catch (ServletException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        catch (BeansException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        this.logger.info((Object)("Framework servlet '" + this.getServletName() + "' init completed in " + elapsedTime + " ms"));
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException {
        this.getServletContext().log("Initializing WebApplicationContext for servlet '" + this.getServletName() + "'");
        ServletContext servletContext = this.getServletConfig().getServletContext();
        WebApplicationContext parent = WebApplicationContextUtils.getWebApplicationContext(servletContext);
        WebApplicationContext wac = this.createWebApplicationContext(parent);
        this.logger.info((Object)("Using context class '" + wac.getClass().getName() + "' for servlet '" + this.getServletName() + "'"));
        if (this.publishContext) {
            String attName = this.getServletContextAttributeName();
            servletContext.setAttribute(attName, (Object)wac);
            this.logger.info((Object)("Bound context of servlet '" + this.getServletName() + "' in ServletContext under name '" + attName + "'"));
        }
        return wac;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext parent) throws BeansException {
        ConfigurableWebApplicationContext wac = null;
        this.logger.info((Object)("Servlet with name '" + this.getServletName() + "' will try to create custom WebApplicationContext context of class '" + this.getContextClass().getName() + "'" + " using parent context [" + parent + "]"));
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = FrameworkServlet.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in servlet with name '" + this.getServletName() + "': custom WebApplicationContext class '" + this.getContextClass().getName() + "' is not of type ConfigurableWebApplicationContext");
        }
        wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(this.getContextClass());
        wac.setParent(parent);
        wac.setServletContext(this.getServletContext());
        wac.setNamespace(this.getNamespace());
        if (this.contextConfigLocation != null) {
            wac.setConfigLocations(WebApplicationContextUtils.parseContextConfigLocation(this.contextConfigLocation));
        }
        wac.refresh();
        return wac;
    }

    public void destroy() {
        this.getServletContext().log("Closing WebApplicationContext for servlet '" + this.getServletName() + "'");
        if (this.getWebApplicationContext() instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)((Object)this.getWebApplicationContext())).close();
        }
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceWrapper(request, response);
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceWrapper(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serviceWrapper(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        Throwable failureCause = null;
        try {
            try {
                this.doService(request, response);
            }
            catch (ServletException ex) {
                failureCause = ex;
                throw ex;
            }
            catch (IOException ex) {
                failureCause = ex;
                throw ex;
            }
            catch (RuntimeException ex) {
                failureCause = ex;
                throw ex;
            }
            catch (Exception ex) {
                failureCause = ex;
                throw new ServletException(ex.getMessage(), (Throwable)ex);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            long processingTime = System.currentTimeMillis() - startTime;
            if (failureCause != null) {
                this.logger.error((Object)"Could not complete request", failureCause);
                this.webApplicationContext.publishEvent(new RequestHandledEvent((Object)this, WebUtils.getRequestUri(request), processingTime, request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName(), failureCause));
                throw throwable;
            }
            this.logger.debug((Object)"Successfully completed request");
            this.webApplicationContext.publishEvent(new RequestHandledEvent((Object)this, WebUtils.getRequestUri(request), processingTime, request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName()));
            throw throwable;
        }
        long processingTime = System.currentTimeMillis() - startTime;
        if (failureCause != null) {
            this.logger.error((Object)"Could not complete request", failureCause);
            this.webApplicationContext.publishEvent(new RequestHandledEvent((Object)this, WebUtils.getRequestUri(request), processingTime, request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName(), failureCause));
            return;
        }
        this.logger.debug((Object)"Successfully completed request");
        this.webApplicationContext.publishEvent(new RequestHandledEvent((Object)this, WebUtils.getRequestUri(request), processingTime, request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName()));
    }

    protected abstract void initFrameworkServlet() throws ServletException, BeansException;

    protected abstract void doService(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

