/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class MultipartFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_MULTIPART_RESOLVER_BEAN_NAME = "filterMultipartResolver";
    private String multipartResolverBeanName = "filterMultipartResolver";
    private MultipartResolver multipartResolver;

    public void setMultipartResolverBeanName(String multipartResolverBeanName) {
        this.multipartResolverBeanName = multipartResolverBeanName;
    }

    protected String getMultipartResolverBeanName() {
        return this.multipartResolverBeanName;
    }

    protected void initFilterBean() throws ServletException {
        this.multipartResolver = this.lookupMultipartResolver();
        if (this.multipartResolver == null) {
            throw new ServletException("Could not determine MultipartResolver");
        }
    }

    protected MultipartResolver lookupMultipartResolver() {
        this.logger.info((Object)("Using MultipartResolver '" + this.getMultipartResolverBeanName() + "' for MultipartFilter"));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        return (MultipartResolver)wac.getBean(this.getMultipartResolverBeanName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest processedRequest = request;
        if (this.multipartResolver.isMultipart(processedRequest)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving request [" + processedRequest.getRequestURI() + "] with MultipartFilter"));
            }
            processedRequest = this.multipartResolver.resolveMultipart(processedRequest);
        }
        try {
            filterChain.doFilter((ServletRequest)processedRequest, (ServletResponse)response);
        }
        finally {
            if (processedRequest instanceof MultipartHttpServletRequest) {
                this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
            }
        }
    }
}

