/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public abstract class WebApplicationContextUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$web$context$support$WebApplicationContextUtils == null ? (class$org$springframework$web$context$support$WebApplicationContextUtils = WebApplicationContextUtils.class$("org.springframework.web.context.support.WebApplicationContextUtils")) : class$org$springframework$web$context$support$WebApplicationContextUtils));
    static /* synthetic */ Class class$org$springframework$web$context$support$WebApplicationContextUtils;

    public static WebApplicationContext getWebApplicationContext(ServletContext sc) {
        return (WebApplicationContext)sc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public static WebApplicationContext getRequiredWebApplicationContext(ServletContext sc) throws IllegalStateException {
        WebApplicationContext wac = (WebApplicationContext)sc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    public static void publishWebApplicationContext(WebApplicationContext wac) {
        ServletContext sc = wac.getServletContext();
        if (sc == null) {
            throw new IllegalArgumentException("ServletContext can't be null in WebApplicationContext " + wac);
        }
        sc.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)wac);
        log.info((Object)("Published root WebApplicationContext [" + wac + "] with ServletContext attribute name '" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "'"));
    }

    public static String[] parseContextConfigLocation(String location) {
        return StringUtils.tokenizeToStringArray(location, ",; ", true, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

