/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.HeuristicCompletionException;
import org.springframework.transaction.InvalidIsolationException;
import org.springframework.transaction.NestedTransactionNotPermittedException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

public class JtaTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private String userTransactionName = "java:comp/UserTransaction";
    private boolean cacheUserTransaction = true;
    private UserTransaction cachedUserTransaction;

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        if (jndiTemplate == null) {
            throw new IllegalArgumentException("jndiTemplate must not be null");
        }
        this.jndiTemplate = jndiTemplate;
    }

    public void setUserTransactionName(String userTransactionName) {
        this.userTransactionName = userTransactionName;
    }

    public void setCacheUserTransaction(boolean cacheUserTransaction) {
        this.cacheUserTransaction = cacheUserTransaction;
    }

    public void afterPropertiesSet() throws CannotCreateTransactionException {
        if (this.cacheUserTransaction) {
            this.cachedUserTransaction = this.lookupUserTransaction();
        }
    }

    protected UserTransaction lookupUserTransaction() throws CannotCreateTransactionException {
        try {
            return (UserTransaction)this.jndiTemplate.lookup(this.userTransactionName);
        }
        catch (NamingException ex) {
            throw new CannotCreateTransactionException("JTA is not available", ex);
        }
    }

    protected Object doGetTransaction() {
        return this.cachedUserTransaction != null ? this.cachedUserTransaction : this.lookupUserTransaction();
    }

    protected boolean isExistingTransaction(Object transaction) {
        try {
            int status = ((UserTransaction)transaction).getStatus();
            return status != 6 && status != 1;
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on getStatus", ex);
        }
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Beginning JTA transaction [" + transaction + "] "));
        }
        UserTransaction ut = (UserTransaction)transaction;
        this.applyIsolationLevel(ut, definition.getIsolationLevel());
        if (definition.isReadOnly()) {
            this.logger.info((Object)"JtaTransactionManager does not support read-only transactions: ignoring 'readOnly' hint");
        }
        try {
            if (definition.getTimeout() > -1) {
                ut.setTransactionTimeout(definition.getTimeout());
            }
            ut.begin();
        }
        catch (NotSupportedException ex) {
            throw new NestedTransactionNotPermittedException("JTA implementation does not support nested transactions", ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new NestedTransactionNotPermittedException("JTA implementation does not support nested transactions", ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on begin", ex);
        }
    }

    protected void applyIsolationLevel(UserTransaction ut, int isolationLevel) {
        if (isolationLevel != -1) {
            throw new InvalidIsolationException("JtaTransactionManager does not support custom isolation levels");
        }
    }

    protected void doCommit(TransactionStatus status) {
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing JTA transaction [" + status.getTransaction() + "]"));
        }
        try {
            ((UserTransaction)status.getTransaction()).commit();
        }
        catch (RollbackException ex) {
            throw new UnexpectedRollbackException("JTA transaction rolled back", ex);
        }
        catch (HeuristicMixedException ex) {
            throw new HeuristicCompletionException(3, (Throwable)ex);
        }
        catch (HeuristicRollbackException ex) {
            throw new HeuristicCompletionException(2, (Throwable)ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on commit", ex);
        }
    }

    protected void doRollback(TransactionStatus status) {
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back JTA transaction [" + status.getTransaction() + "]"));
        }
        try {
            ((UserTransaction)status.getTransaction()).rollback();
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on rollback", ex);
        }
    }

    protected void doSetRollbackOnly(TransactionStatus status) {
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JTA transaction [" + status.getTransaction() + "] rollback-only"));
        }
        try {
            ((UserTransaction)status.getTransaction()).setRollbackOnly();
        }
        catch (IllegalStateException ex) {
            throw new NoTransactionException("No active JTA transaction");
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on setRollbackOnly", ex);
        }
    }
}

