/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.util.Constants;

public abstract class HibernateAccessor
implements InitializingBean {
    public static final int FLUSH_NEVER = 0;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EAGER = 2;
    private static final Constants constants = new Constants(class$org$springframework$orm$hibernate$HibernateAccessor == null ? (class$org$springframework$orm$hibernate$HibernateAccessor = HibernateAccessor.class$("org.springframework.orm.hibernate.HibernateAccessor")) : class$org$springframework$orm$hibernate$HibernateAccessor);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;
    private Interceptor entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator = new SQLStateSQLExceptionTranslator();
    private int flushMode = 1;
    static /* synthetic */ Class class$org$springframework$orm$hibernate$HibernateAccessor;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() {
        return this.entityInterceptor;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void setFlushModeName(String constantName) {
        this.setFlushMode(constants.asNumber(constantName).intValue());
    }

    public void setFlushMode(int flushMode) {
        this.flushMode = flushMode;
    }

    public int getFlushMode() {
        return this.flushMode;
    }

    public void afterPropertiesSet() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    protected void flushIfNecessary(Session session, boolean existingTransaction) throws HibernateException {
        if (this.getFlushMode() == 2 || !existingTransaction && this.getFlushMode() == 1) {
            this.logger.debug((Object)"Eagerly flushing Hibernate session");
            session.flush();
        }
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return this.convertJdbcAccessException(((JDBCException)ex).getSQLException());
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        if (this.jdbcExceptionTranslator != null) {
            return this.jdbcExceptionTranslator.translate("HibernateAccessor", null, ex);
        }
        return new HibernateJdbcException(ex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

