/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class JavaMailSenderImpl
implements JavaMailSender {
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final int DEFAULT_PORT = -1;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Session session = Session.getInstance((Properties)new Properties());
    private String protocol = "smtp";
    private String host;
    private int port = -1;
    private String username;
    private String password;

    public void setSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Cannot work with a null Session");
        }
        this.session = session;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            for (int i = 0; i < simpleMessages.length; ++i) {
                int j;
                SimpleMailMessage simpleMessage = simpleMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending email using the following mail properties [" + simpleMessage + "]"));
                }
                MimeMessage mimeMessage = this.createMimeMessage();
                if (simpleMessage.getFrom() != null) {
                    mimeMessage.setFrom((Address)new InternetAddress(simpleMessage.getFrom()));
                }
                if (simpleMessage.getTo() != null) {
                    mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(simpleMessage.getTo()));
                }
                if (simpleMessage.getCc() != null) {
                    for (j = 0; j < simpleMessage.getCc().length; ++j) {
                        mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(simpleMessage.getCc()[j]));
                    }
                }
                if (simpleMessage.getBcc() != null) {
                    for (j = 0; j < simpleMessage.getBcc().length; ++j) {
                        mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(simpleMessage.getBcc()[j]));
                    }
                }
                if (simpleMessage.getSubject() != null) {
                    mimeMessage.setSubject(simpleMessage.getSubject());
                }
                if (simpleMessage.getText() != null) {
                    mimeMessage.setText(simpleMessage.getText());
                }
                mimeMessages.add(mimeMessage);
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), simpleMessages);
        }
        catch (MessagingException ex) {
            throw new MailParseException(ex);
        }
    }

    public MimeMessage createMimeMessage() {
        return new MimeMessage(this.session);
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.send(new MimeMessage[]{mimeMessage});
    }

    public void send(MimeMessage[] mimeMessages) throws MailException {
        this.send(mimeMessages, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MimeMessage[] mimeMessages, Object[] originalMessages) throws MailException {
        HashMap<MimeMessage, MessagingException> failedMessages = new HashMap<MimeMessage, MessagingException>();
        try {
            Transport transport = this.getTransport(this.session);
            transport.connect(this.host, this.port, this.username, this.password);
            try {
                for (int i = 0; i < mimeMessages.length; ++i) {
                    MimeMessage mimeMessage = mimeMessages[i];
                    try {
                        mimeMessage.saveChanges();
                        transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                        continue;
                    }
                    catch (MessagingException ex) {
                        MimeMessage original = originalMessages != null ? originalMessages[i] : mimeMessage;
                        failedMessages.put(original, ex);
                    }
                }
            }
            finally {
                transport.close();
            }
        }
        catch (AuthenticationFailedException ex) {
            throw new MailAuthenticationException(ex);
        }
        catch (MessagingException ex) {
            throw new MailSendException("Mail server connection failed", ex);
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.send(new MimeMessagePreparator[]{mimeMessagePreparator});
    }

    public void send(MimeMessagePreparator[] mimeMessagePreparators) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            for (int i = 0; i < mimeMessagePreparators.length; ++i) {
                MimeMessage mimeMessage = this.createMimeMessage();
                mimeMessagePreparators[i].prepare(mimeMessage);
                mimeMessages.add(mimeMessage);
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]));
        }
        catch (MessagingException ex) {
            throw new MailParseException(ex);
        }
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(this.protocol);
    }
}

