/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.ContextCallback;

public class JndiTemplate {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String name) throws NamingException {
        Object object;
        Context ctx = null;
        try {
            ctx = this.createInitialContext();
            this.logger.debug((Object)("Looking up JNDI object with name '" + name + "'"));
            Object lookedUp = ctx.lookup(name);
            if (lookedUp == null) {
                throw new NamingException("JNDI object not found: JNDI implementation returned null");
            }
            object = lookedUp;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException ex) {
                this.logger.warn((Object)"InitialContext threw exception on close", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException ex) {
            this.logger.warn((Object)"InitialContext threw exception on close", (Throwable)ex);
        }
        return object;
    }

    public void bind(final String name, final Object object) throws NamingException {
        this.execute(new ContextCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                JndiTemplate.this.logger.info((Object)("Binding JNDI object with name " + name));
                ctx.bind(name, object);
                return null;
            }
        });
    }

    public void unbind(final String name) throws NamingException {
        this.execute(new ContextCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                JndiTemplate.this.logger.info((Object)("Unbinding JNDI object with name " + name));
                ctx.unbind(name);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ContextCallback contextCallback) throws NamingException {
        Object object;
        Context ctx = null;
        try {
            ctx = this.createInitialContext();
            object = contextCallback.doInContext(ctx);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException ex) {
                this.logger.warn((Object)"InitialContext threw exception on close", (Throwable)ex);
            }
            throw throwable;
        }
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException ex) {
            this.logger.warn((Object)"InitialContext threw exception on close", (Throwable)ex);
        }
        return object;
    }

    protected Context createInitialContext() throws NamingException {
        return new InitialContext(this.getEnvironment());
    }
}

