/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.lob.BlobCreator;
import org.springframework.jdbc.support.lob.DefaultBlobImpl;
import org.springframework.jdbc.support.lob.LobHandler;

public class DefaultLobHandler
implements LobHandler {
    public BlobCreator getBlobCreator() {
        return new DefaultBlobCreator();
    }

    protected static class DefaultBlobCreator
    implements BlobCreator {
        protected final Log logger = LogFactory.getLog(this.getClass());

        protected DefaultBlobCreator() {
        }

        public Blob createBlob(Connection con, byte[] content) {
            DefaultBlobImpl blob = new DefaultBlobImpl(content);
            this.logger.debug((Object)("Created new DefaultBlobImpl with length " + blob.length()));
            return blob;
        }

        public Blob createBlob(Connection con, InputStream contentStream) throws IOException {
            DefaultBlobImpl blob = new DefaultBlobImpl(contentStream);
            this.logger.debug((Object)("Created new DefaultBlobImpl with length " + blob.length()));
            return blob;
        }

        public void setBlobAsBytes(PreparedStatement ps, int parameterIndex, byte[] content) throws SQLException {
            ps.setBytes(parameterIndex, content);
            this.logger.debug((Object)("Set bytes for BLOB with length " + content.length));
        }

        public void setBlobAsBinaryStream(PreparedStatement ps, int parameterIndex, InputStream contentStream) throws SQLException, IOException {
            int contentLength = contentStream.available();
            ps.setBinaryStream(parameterIndex, contentStream, contentLength);
            this.logger.debug((Object)("Set binary stream for BLOB with length " + contentLength));
        }

        public void close() {
        }
    }
}

