/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.springframework.util.FileCopyUtils;

public class DefaultBlobImpl
implements Blob {
    private final InputStream contentStream;
    private final int contentLength;

    public DefaultBlobImpl(byte[] content) {
        this.contentStream = new ByteArrayInputStream(content);
        this.contentLength = content.length;
    }

    public DefaultBlobImpl(InputStream contentStream) throws IOException {
        this.contentStream = contentStream;
        this.contentLength = contentStream.available();
    }

    public InputStream getBinaryStream() {
        return this.contentStream;
    }

    public long length() {
        return this.contentLength;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.contentLength);
        try {
            FileCopyUtils.copy(this.contentStream, baos);
        }
        catch (IOException ex) {
            throw new SQLException("Could not read input stream: " + ex.getMessage());
        }
        return baos.toByteArray();
    }

    public OutputStream setBinaryStream(long arg0) {
        throw new UnsupportedOperationException("Blob may not be manipulated other than via constructors");
    }

    public int setBytes(long arg0, byte[] arg1) {
        throw new UnsupportedOperationException("Blob may not be manipulated other than via constructors");
    }

    public int setBytes(long arg0, byte[] arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException("Blob may not be manipulated other than via constructors");
    }

    public void truncate(long arg0) {
        throw new UnsupportedOperationException("Blob may not be manipulated other than via constructors");
    }

    public long position(byte[] arg0, long arg1) {
        throw new UnsupportedOperationException("Blob may not be manipulated other than via constructors");
    }

    public long position(Blob arg0, long arg1) {
        throw new UnsupportedOperationException("Blob may not be manipulated other than via constructors");
    }
}

