/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NestingMessageSource;
import org.springframework.context.NoSuchMessageException;

public abstract class AbstractNestingMessageSource
implements NestingMessageSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MessageSource parent;
    private Map formats = new HashMap();

    public final void setParent(MessageSource parent) {
        this.parent = parent;
    }

    public final String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        try {
            return this.getMessage(code, args, locale);
        }
        catch (NoSuchMessageException ex) {
            return defaultMessage;
        }
    }

    public final String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String[] codes = resolvable.getCodes();
        for (int i = 0; i < codes.length; ++i) {
            try {
                return this.getMessage(codes[i], resolvable.getArgs(), locale);
            }
            catch (NoSuchMessageException ex) {
                continue;
            }
        }
        if (resolvable.getDefaultMessage() != null) {
            return resolvable.getDefaultMessage();
        }
        throw new NoSuchMessageException(codes[codes.length - 1], locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String mesg = this.resolve(code, locale);
        if (mesg == null) {
            if (this.parent != null) {
                mesg = this.parent.getMessage(code, args, locale);
            } else {
                this.logger.debug((Object)("Could not resolve message code [" + code + "] in locale [" + locale + "]"));
                throw new NoSuchMessageException(code, locale);
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        MessageFormat format = null;
        String formatKey = this.messageKey(locale, code);
        Map map = this.formats;
        synchronized (map) {
            format = (MessageFormat)this.formats.get(formatKey);
            if (format == null) {
                format = new MessageFormat(mesg);
                this.formats.put(formatKey, format);
            }
        }
        return format.format(args);
    }

    protected String messageKey(Locale locale, String key) {
        return this.localeKey(locale) + "." + key;
    }

    protected String localeKey(Locale locale) {
        if (locale == null || locale.equals(Locale.getDefault())) {
            return "";
        }
        return locale.toString();
    }

    protected abstract String resolve(String var1, Locale var2);
}

