/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class PropertiesFactoryBean
implements FactoryBean,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource location;
    private Properties properties;
    private boolean singleton = true;
    private Properties singletonInstance;
    static /* synthetic */ Class class$java$util$Properties;

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.location == null && this.properties == null) {
            throw new IllegalArgumentException("Either location or properties must be set");
        }
        if (this.singleton) {
            this.singletonInstance = this.mergeProperties();
        }
    }

    public Object getObject() throws IOException {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.mergeProperties();
    }

    protected Properties mergeProperties() throws IOException {
        Properties result;
        Properties properties = result = this.location != null ? this.loadProperties() : new Properties();
        if (this.properties != null) {
            result.putAll((Map<?, ?>)this.properties);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties() throws IOException {
        this.logger.info((Object)("Loading properties file from class path location [" + this.location + "]"));
        Properties properties = new Properties();
        InputStream is = this.location.getInputStream();
        try {
            properties.load(is);
        }
        finally {
            is.close();
        }
        return properties;
    }

    public Class getObjectType() {
        return class$java$util$Properties == null ? (class$java$util$Properties = PropertiesFactoryBean.class$("java.util.Properties")) : class$java$util$Properties;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

