/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.core.ErrorCoded;

public class InvalidPropertyValuesException
extends BeansException {
    private List missingFields = new LinkedList();
    private PropertyValues pvs;

    public InvalidPropertyValuesException(PropertyValues pvs) {
        super("InvalidPropertyValues");
        this.pvs = pvs;
    }

    public void addMissingField(String field, String errorCode) {
        this.missingFields.add(new MissingFieldException(field, errorCode));
    }

    public boolean fieldsAreMissing() {
        return this.missingFields.size() > 0;
    }

    public List getMissingFields() {
        return this.missingFields;
    }

    public PropertyValues getPropertyValues() {
        return this.pvs;
    }

    public static class MissingFieldException
    extends Exception
    implements ErrorCoded {
        private String field;
        private String errorCode;

        public MissingFieldException(String field, String errorCode) {
            super("Field '" + field + "' is required");
            this.field = field;
            this.errorCode = errorCode;
        }

        public String getField() {
            return this.field;
        }

        public String getErrorCode() {
            return this.errorCode;
        }
    }
}

