/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractPrototypeTargetSource
implements TargetSource,
BeanFactoryAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String targetBeanName;
    private BeanFactory owningBeanFactory;
    private Class targetClass;

    public final void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public final String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.owningBeanFactory = beanFactory;
        if (this.owningBeanFactory.isSingleton(this.targetBeanName)) {
            throw new BeanDefinitionStoreException("Cannot use PrototypeTargetSource against a Singleton bean; instances would not be independent", null);
        }
        this.logger.info((Object)("Getting bean with name '" + this.targetBeanName + "' to find class"));
        this.targetClass = this.owningBeanFactory.getBean(this.targetBeanName).getClass();
    }

    protected Object newPrototypeInstance() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating new target from bean '" + this.targetBeanName + "'"));
        }
        return this.owningBeanFactory.getBean(this.targetBeanName);
    }

    public final Class getTargetClass() {
        return this.targetClass;
    }

    public final boolean isStatic() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.targetBeanName == null) {
            throw new IllegalStateException("targetBeanName property must be set.");
        }
    }
}

