/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy.target;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.TargetSourceCreator;
import org.springframework.aop.target.AbstractPrototypeTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public abstract class AbstractPrototypeTargetSourceCreator
implements TargetSourceCreator {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public final TargetSource getTargetSource(Object bean, String beanName, BeanFactory factory) {
        AbstractPrototypeTargetSource prototypeTargetSource = this.createPrototypeTargetSource(bean, beanName, factory);
        if (prototypeTargetSource == null) {
            return null;
        }
        if (!(factory instanceof BeanDefinitionRegistry)) {
            this.logger.warn((Object)"Cannot do autopooling with a BeanFactory that doesn't implement BeanDefinitionRegistry");
            return null;
        }
        BeanDefinitionRegistry definitionRegistry = (BeanDefinitionRegistry)((Object)factory);
        RootBeanDefinition definition = (RootBeanDefinition)definitionRegistry.getBeanDefinition(beanName);
        this.logger.info((Object)"Configuring AbstractPrototypeTargetSource...");
        DefaultListableBeanFactory beanFactory2 = new DefaultListableBeanFactory(factory);
        beanFactory2.registerBeanDefinition(beanName, definition);
        prototypeTargetSource.setTargetBeanName(beanName);
        prototypeTargetSource.setBeanFactory(beanFactory2);
        return prototypeTargetSource;
    }

    protected abstract AbstractPrototypeTargetSource createPrototypeTargetSource(Object var1, String var2, BeanFactory var3);
}

