/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.aopalliance.intercept.AttributeRegistry;
import org.aopalliance.intercept.Invocation;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;

public class ReflectiveMethodInvocation
implements MethodInvocation {
    protected Class targetInterface;
    protected Method method;
    protected Object[] arguments;
    protected Object target;
    protected Object proxy;
    protected List interceptorsAndDynamicMethodMatchers;
    private HashMap resources;
    private int currentInterceptorIndex = -1;
    private Class targetClass;

    public ReflectiveMethodInvocation(Object proxy, Object target, Class targetInterface, Method m, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers) {
        this.proxy = proxy;
        this.target = target;
        this.targetInterface = targetInterface;
        this.targetClass = targetClass;
        this.method = m;
        this.arguments = arguments;
        this.interceptorsAndDynamicMethodMatchers = interceptorsAndDynamicMethodMatchers;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final AccessibleObject getStaticPart() {
        return this.method;
    }

    public final Object getProxy() {
        return this.proxy;
    }

    public String toString() {
        String s = "Invocation: method=[" + this.method + "] " + "args=" + this.arguments + "] ";
        s = s + (this.target == null ? "target is null" : "target is of class " + this.target.getClass().getName());
        return s;
    }

    public Object addAttachment(String key, Object resource) {
        if (this.resources == null) {
            this.resources = new HashMap();
        }
        Object oldValue = this.resources.get(key);
        this.resources.put(key, resource);
        return oldValue;
    }

    public Object getAttachment(String key) {
        return this.resources == null ? null : this.resources.get(key);
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public Object getArgument(int i) {
        return this.arguments[i];
    }

    public int getArgumentCount() {
        return this.arguments != null ? this.arguments.length : 0;
    }

    public final Class getTargetInterface() {
        return this.targetInterface;
    }

    public Object proceed() throws Throwable {
        Object interceptorOrInterceptionAdvice;
        if (this.currentInterceptorIndex == this.interceptorsAndDynamicMethodMatchers.size() - 1) {
            return this.invokeJoinpoint();
        }
        if ((interceptorOrInterceptionAdvice = this.interceptorsAndDynamicMethodMatchers.get(++this.currentInterceptorIndex)) instanceof InterceptorAndDynamicMethodMatcher) {
            InterceptorAndDynamicMethodMatcher dm = (InterceptorAndDynamicMethodMatcher)interceptorOrInterceptionAdvice;
            if (dm.methodMatcher.matches(this.method, this.targetClass, this.arguments)) {
                return dm.interceptor.invoke((MethodInvocation)this);
            }
            return this.proceed();
        }
        return ((MethodInterceptor)interceptorOrInterceptionAdvice).invoke((MethodInvocation)this);
    }

    protected Object invokeJoinpoint() throws Throwable {
        return AopProxyUtils.invokeJoinpointUsingReflection(this.target, this.method, this.arguments);
    }

    public Invocation cloneInstance() {
        throw new UnsupportedOperationException();
    }

    public AttributeRegistry getAttributeRegistry() {
        throw new UnsupportedOperationException("Likely to be removed from AOP Alliance API");
    }

    public void setArgument(int index, Object argument) {
        this.arguments[index] = argument;
    }

    public final Object getThis() {
        return this.target;
    }
}

