/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultReader;
import org.springframework.jdbc.core.SqlParameter;

public class ResultSetSupportingSqlParameter
extends SqlParameter {
    private ResultSetExtractor resultSetExtractor;
    private RowCallbackHandler rowCallbackHandler;
    private RowMapper rowMapper;
    private int rowsExpected = 0;

    public ResultSetSupportingSqlParameter(String name, int sqlType) {
        super(name, sqlType);
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, String typeName) {
        super(name, sqlType, typeName);
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, ResultSetExtractor rse) {
        super(name, sqlType);
        this.resultSetExtractor = rse;
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, RowCallbackHandler rch) {
        super(name, sqlType);
        this.rowCallbackHandler = rch;
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, RowMapper rm) {
        super(name, sqlType);
        this.rowMapper = rm;
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, RowMapper rm, int rowsExpected) {
        super(name, sqlType);
        this.rowMapper = rm;
        this.rowsExpected = rowsExpected;
    }

    public boolean isResultSetSupported() {
        return this.resultSetExtractor != null || this.rowCallbackHandler != null || this.rowMapper != null;
    }

    public boolean isRowCallbackHandlerSupported() {
        return this.rowCallbackHandler != null || this.rowMapper != null;
    }

    public ResultSetExtractor getResultSetExtractor() {
        return this.resultSetExtractor;
    }

    public RowCallbackHandler getRowCallbackHandler() {
        if (this.rowMapper != null) {
            return new RowMapperResultReader(this.rowMapper, this.rowsExpected);
        }
        return this.rowCallbackHandler;
    }
}

