/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.lob.BlobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.FileCopyUtils;

public class OracleLobHandler
implements LobHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private NativeJdbcExtractor nativeJdbcExtractor;
    static /* synthetic */ Class class$java$sql$Connection;

    public void setNativeJdbcExtractor(NativeJdbcExtractor extractor) {
        this.nativeJdbcExtractor = extractor;
    }

    public BlobCreator getBlobCreator() {
        return new OracleBlobCreator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class OracleBlobCreator
    implements BlobCreator {
        private static final int DURATION_SESSION = 10;
        private static final int MODE_READWRITE = 1;
        private final List createdBlobs = new ArrayList();

        protected OracleBlobCreator() {
        }

        public Blob createBlob(Connection con, byte[] content) throws SQLException {
            Connection conToUse = OracleLobHandler.this.nativeJdbcExtractor != null ? OracleLobHandler.this.nativeJdbcExtractor.getNativeConnection(con) : con;
            return this.doCreateBlob(conToUse, content);
        }

        public Blob createBlob(Connection con, InputStream contentStream) throws SQLException, IOException {
            Connection conToUse = OracleLobHandler.this.nativeJdbcExtractor != null ? OracleLobHandler.this.nativeJdbcExtractor.getNativeConnection(con) : con;
            return this.doCreateBlob(conToUse, contentStream);
        }

        public void setBlobAsBytes(PreparedStatement ps, int parameterIndex, byte[] content) throws SQLException {
            Connection conToUse = OracleLobHandler.this.nativeJdbcExtractor != null ? OracleLobHandler.this.nativeJdbcExtractor.getNativeConnectionFromStatement(ps) : ps.getConnection();
            ps.setBlob(parameterIndex, this.doCreateBlob(conToUse, content));
        }

        public void setBlobAsBinaryStream(PreparedStatement ps, int parameterIndex, InputStream contentStream) throws SQLException, IOException {
            Connection conToUse = OracleLobHandler.this.nativeJdbcExtractor != null ? OracleLobHandler.this.nativeJdbcExtractor.getNativeConnectionFromStatement(ps) : ps.getConnection();
            ps.setBlob(parameterIndex, this.doCreateBlob(conToUse, contentStream));
        }

        protected Blob doCreateBlob(Connection con, byte[] content) throws SQLException {
            try {
                Blob blob = this.prepareBlob(con);
                this.getBinaryOutputStream(blob).write(content);
                this.closeBlob(blob);
                this.createdBlobs.add(blob);
                OracleLobHandler.this.logger.debug((Object)("Created new Oracle BLOB with length " + blob.length()));
                return blob;
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof SQLException) {
                    throw (SQLException)ex.getTargetException();
                }
                throw new DataAccessResourceFailureException("Could not create Oracle BLOB", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not create Oracle BLOB", ex);
            }
        }

        protected Blob doCreateBlob(Connection con, InputStream contentStream) throws SQLException, IOException {
            try {
                Blob blob = this.prepareBlob(con);
                FileCopyUtils.copy(contentStream, this.getBinaryOutputStream(blob));
                this.closeBlob(blob);
                this.createdBlobs.add(blob);
                OracleLobHandler.this.logger.debug((Object)("Created new Oracle BLOB with length " + blob.length()));
                return blob;
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof SQLException) {
                    throw (SQLException)ex.getTargetException();
                }
                if (ex.getTargetException() instanceof IOException) {
                    throw (IOException)ex.getTargetException();
                }
                throw new DataAccessResourceFailureException("Could not create Oracle BLOB", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not create Oracle BLOB", ex);
            }
        }

        protected Blob prepareBlob(Connection con) throws Exception {
            Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection");
            if (!oracleConnectionClass.isAssignableFrom(con.getClass())) {
                throw new InvalidDataAccessApiUsageException("OracleBlobCreator needs to work on OracleConnection - maybe set the nativeJdbcExtractor property?");
            }
            Class<?> blobClass = Class.forName("oracle.sql.BLOB");
            Method createTemporary = blobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = OracleLobHandler.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            Object blob = createTemporary.invoke(null, con, Boolean.FALSE, new Integer(10));
            Method open = blobClass.getMethod("open", Integer.TYPE);
            open.invoke(blob, new Integer(1));
            return (Blob)blob;
        }

        protected OutputStream getBinaryOutputStream(Blob blob) throws Exception {
            Method getBinaryOutputStream = blob.getClass().getMethod("getBinaryOutputStream", null);
            return (OutputStream)getBinaryOutputStream.invoke((Object)blob, null);
        }

        protected void closeBlob(Blob blob) throws Exception {
            Method close = blob.getClass().getMethod("close", null);
            close.invoke((Object)blob, null);
        }

        public void close() throws SQLException {
            try {
                Iterator it = this.createdBlobs.iterator();
                while (it.hasNext()) {
                    Blob blob = (Blob)it.next();
                    Method freeTemporary = blob.getClass().getMethod("freeTemporary", new Class[0]);
                    freeTemporary.invoke((Object)blob, new Object[0]);
                }
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof SQLException) {
                    throw (SQLException)ex.getTargetException();
                }
                throw new DataAccessResourceFailureException("Could not free Oracle BLOB", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not free Oracle BLOB", ex);
            }
        }
    }
}

