/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.InternalErrorException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.AbstractNextMaxValueProvider;

public class HsqlMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private long[] valueCache = null;
    private NextMaxValueProvider nextMaxValueProvider = new NextMaxValueProvider();

    public HsqlMaxValueIncrementer() {
    }

    public HsqlMaxValueIncrementer(DataSource ds, String incrementerName, String columnName) {
        super(ds, incrementerName, columnName);
    }

    public HsqlMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, int cacheSize) {
        super(ds, incrementerName, columnName, cacheSize);
    }

    public HsqlMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, boolean prefixWithZero, int padding) {
        super(ds, incrementerName, columnName);
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, padding);
    }

    public HsqlMaxValueIncrementer(DataSource ds, String incrementerName, String columnName, boolean prefixWithZero, int padding, int cacheSize) {
        super(ds, incrementerName, columnName, cacheSize);
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, padding);
    }

    public void setPrefixWithZero(boolean prefixWithZero, int length) {
        this.nextMaxValueProvider.setPrefixWithZero(prefixWithZero, length);
    }

    protected int incrementIntValue() {
        return this.nextMaxValueProvider.getNextIntValue();
    }

    protected long incrementLongValue() {
        return this.nextMaxValueProvider.getNextLongValue();
    }

    protected double incrementDoubleValue() {
        return this.nextMaxValueProvider.getNextDoubleValue();
    }

    protected String incrementStringValue() {
        return this.nextMaxValueProvider.getNextStringValue();
    }

    static /* synthetic */ long[] access$102(HsqlMaxValueIncrementer x0, long[] x1) {
        x0.valueCache = x1;
        return x1;
    }

    private class NextMaxValueProvider
    extends AbstractNextMaxValueProvider {
        private String insertSql;
        private String valueSql;
        private String deleteSql;
        private int nextValueIx = -1;

        private NextMaxValueProvider() {
        }

        /*
         * Loose catch block
         */
        protected synchronized long getNextKey(int type) throws DataAccessException {
            block18: {
                SQLException e2;
                ResultSet rs;
                Statement stmt;
                Connection con;
                block16: {
                    if (HsqlMaxValueIncrementer.this.isDirty()) {
                        this.initPrepare();
                    }
                    if (this.nextValueIx >= 0 && this.nextValueIx < HsqlMaxValueIncrementer.this.getCacheSize()) break block18;
                    con = null;
                    stmt = null;
                    rs = null;
                    con = DataSourceUtils.getConnection(HsqlMaxValueIncrementer.this.getDataSource());
                    stmt = con.createStatement();
                    DataSourceUtils.applyTransactionTimeout(stmt, HsqlMaxValueIncrementer.this.getDataSource());
                    HsqlMaxValueIncrementer.access$102(HsqlMaxValueIncrementer.this, new long[HsqlMaxValueIncrementer.this.getCacheSize()]);
                    this.nextValueIx = 0;
                    for (int i = 0; i < HsqlMaxValueIncrementer.this.getCacheSize(); ++i) {
                        stmt.executeUpdate(this.insertSql);
                        rs = stmt.executeQuery(this.valueSql);
                        if (!rs.next()) {
                            throw new InternalErrorException("last_insert_id() failed after executing an update");
                        }
                        ((HsqlMaxValueIncrementer)HsqlMaxValueIncrementer.this).valueCache[i] = rs.getLong(1);
                    }
                    long maxValue = HsqlMaxValueIncrementer.this.valueCache[HsqlMaxValueIncrementer.this.valueCache.length - 1];
                    stmt.executeUpdate(this.deleteSql + maxValue);
                    Object var8_8 = null;
                    if (null == rs) break block16;
                    try {
                        rs.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                if (null == stmt) break block18;
                try {
                    stmt.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                DataSourceUtils.closeConnectionIfNecessary(con, HsqlMaxValueIncrementer.this.getDataSource());
                {
                    break block18;
                    catch (SQLException ex) {
                        throw new DataAccessResourceFailureException("Could not obtain last_insert_id", ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    if (null != stmt) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                        DataSourceUtils.closeConnectionIfNecessary(con, HsqlMaxValueIncrementer.this.getDataSource());
                    }
                    throw throwable;
                }
            }
            if (HsqlMaxValueIncrementer.this.logger.isInfoEnabled()) {
                HsqlMaxValueIncrementer.this.logger.info((Object)("Next sequence value is : " + HsqlMaxValueIncrementer.this.valueCache[this.nextValueIx]));
            }
            return HsqlMaxValueIncrementer.this.valueCache[this.nextValueIx++];
        }

        private void initPrepare() {
            if (HsqlMaxValueIncrementer.this.getIncrementerName() == null) {
                throw new IllegalArgumentException("incrementerName property must be set on " + this.getClass().getDeclaringClass().getName());
            }
            if (HsqlMaxValueIncrementer.this.getColumnName() == null) {
                throw new IllegalArgumentException("columnName property must be set on " + this.getClass().getDeclaringClass().getName());
            }
            StringBuffer buf = new StringBuffer();
            buf.append("insert into ");
            buf.append(HsqlMaxValueIncrementer.this.getIncrementerName());
            buf.append(" values(null)");
            this.insertSql = buf.toString();
            if (HsqlMaxValueIncrementer.this.logger.isInfoEnabled()) {
                HsqlMaxValueIncrementer.this.logger.info((Object)("insertSql = " + this.insertSql));
            }
            this.valueSql = "select max(identity()) from " + HsqlMaxValueIncrementer.this.getIncrementerName();
            this.nextValueIx = -1;
            buf = new StringBuffer();
            buf.append("delete from ");
            buf.append(HsqlMaxValueIncrementer.this.getIncrementerName());
            buf.append(" where ");
            buf.append(HsqlMaxValueIncrementer.this.getColumnName());
            buf.append(" < ");
            this.deleteSql = buf.toString();
            HsqlMaxValueIncrementer.this.setDirty(false);
        }
    }
}

