/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ConstructorArgumentValues;

public class RootBeanDefinition
extends AbstractBeanDefinition {
    public static final int DEPENDENCY_CHECK_NONE = 0;
    public static final int DEPENDENCY_CHECK_OBJECTS = 1;
    public static final int DEPENDENCY_CHECK_SIMPLE = 2;
    public static final int DEPENDENCY_CHECK_ALL = 3;
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    public static final int AUTOWIRE_CONSTRUCTOR = 3;
    private Class beanClass;
    private ConstructorArgumentValues constructorArgumentValues;
    private String[] dependsOn;
    private int dependencyCheck = 0;
    private int autowire = 0;
    private String initMethodName;
    private String destroyMethodName;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public RootBeanDefinition(Class beanClass, PropertyValues pvs) {
        super(pvs);
        this.beanClass = beanClass;
    }

    public RootBeanDefinition(Class beanClass, PropertyValues pvs, boolean singleton) {
        super(pvs);
        this.beanClass = beanClass;
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, ConstructorArgumentValues cargs, PropertyValues pvs) {
        super(pvs);
        this.beanClass = beanClass;
        this.constructorArgumentValues = cargs;
    }

    public RootBeanDefinition(Class beanClass, ConstructorArgumentValues cargs, PropertyValues pvs, boolean singleton) {
        super(pvs);
        this.beanClass = beanClass;
        this.constructorArgumentValues = cargs;
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, PropertyValues pvs, boolean singleton, int dependencyCheck, int autowire) {
        super(pvs);
        this.beanClass = beanClass;
        this.setSingleton(singleton);
        this.setDependencyCheck(dependencyCheck);
        this.setAutowire(autowire);
    }

    public RootBeanDefinition(RootBeanDefinition other) {
        super(new MutablePropertyValues(other.getPropertyValues()));
        this.beanClass = other.beanClass;
        this.constructorArgumentValues = other.constructorArgumentValues;
        this.setSingleton(other.isSingleton());
        this.setLazyInit(other.isLazyInit());
        this.setDependsOn(other.getDependsOn());
        this.setDependencyCheck(other.getDependencyCheck());
        this.setAutowire(other.getAutowire());
        this.setInitMethodName(other.getInitMethodName());
        this.setDestroyMethodName(other.getDestroyMethodName());
    }

    public final Class getBeanClass() {
        return this.beanClass;
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.constructorArgumentValues;
    }

    public boolean hasConstructorArgumentValues() {
        return this.constructorArgumentValues != null && !this.constructorArgumentValues.isEmpty();
    }

    public void setDependsOn(String[] dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public void setDependencyCheck(int dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public int getDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setAutowire(int autowire) {
        this.autowire = autowire;
    }

    public int getAutowire() {
        return this.autowire;
    }

    public void setInitMethodName(String initMethodName) {
        this.initMethodName = initMethodName;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setDestroyMethodName(String destroyMethodName) {
        this.destroyMethodName = destroyMethodName;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void validate() throws BeanDefinitionValidationException {
        super.validate();
        if (this.beanClass == null) {
            throw new BeanDefinitionValidationException("beanClass must be set in RootBeanDefinition");
        }
        if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = RootBeanDefinition.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(this.beanClass) && !this.isSingleton()) {
            throw new BeanDefinitionValidationException("FactoryBean must be defined as singleton - FactoryBeans themselves are not allowed to be prototypes");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RootBeanDefinition)) {
            return false;
        }
        return super.equals(obj) && ((RootBeanDefinition)obj).getBeanClass().equals(this.getBeanClass());
    }

    public String toString() {
        return "Root bean definition with class [" + this.getBeanClass().getName() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

