/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public abstract class Log4jConfigurer {
    public static final long DEFAULT_REFRESH_INTERVAL = 60000L;
    public static final String XML_FILE_EXTENSION = ".xml";

    public static void initLogging(String location) throws FileNotFoundException {
        if (!new File(location).exists()) {
            throw new FileNotFoundException("Log4J config file [" + location + "] not found");
        }
        if (location.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configure((String)location);
        } else {
            PropertyConfigurator.configure((String)location);
        }
    }

    public static void initLogging(String location, long refreshInterval) throws FileNotFoundException {
        if (!new File(location).exists()) {
            throw new FileNotFoundException("Log4J config file [" + location + "] not found");
        }
        if (location.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configureAndWatch((String)location, (long)refreshInterval);
        } else {
            PropertyConfigurator.configureAndWatch((String)location, (long)refreshInterval);
        }
    }

    public static void shutdownLogging() {
        LogManager.shutdown();
    }

    public static void setWorkingDirSystemProperty(String key) {
        System.setProperty(key, new File("").getAbsolutePath());
    }
}

