/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
        this.classLoader = classLoader;
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader, ClassLoader classLoader) {
        this.resourceLoader = resourceLoader;
        this.classLoader = classLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Resource getResource(String location) {
        return this.resourceLoader.getResource(location);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("classpath*:")) {
            if (PathMatcher.isPattern(locationPattern.substring("classpath*:".length()))) {
                return this.findPathMatchingResources(locationPattern);
            }
            return this.findAllClassPathResources(locationPattern.substring("classpath*:".length()));
        }
        if (PathMatcher.isPattern(locationPattern)) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.resourceLoader.getResource(locationPattern)};
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        ClassLoader cl;
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((cl = this.classLoader) == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Enumeration<URL> resourceUrls = cl.getResources(path);
        ArrayList<UrlResource> result = new ArrayList<UrlResource>();
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(new UrlResource(url));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        ArrayList result = new ArrayList();
        for (int i = 0; i < rootDirResources.length; ++i) {
            Resource rootDirResource = rootDirResources[i];
            if ("jar".equals(rootDirResource.getURL().getProtocol())) {
                result.addAll(this.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Resolved location pattern [" + locationPattern + "] to resources " + result));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected String determineRootDir(String location) {
        int rootDirEnd;
        int patternStart = location.length();
        int prefixEnd = location.indexOf(":");
        int asteriskIndex = location.indexOf(42, prefixEnd);
        int questionMarkIndex = location.indexOf(63, prefixEnd);
        if (asteriskIndex != -1 || questionMarkIndex != -1) {
            int n = patternStart = asteriskIndex > questionMarkIndex ? asteriskIndex : questionMarkIndex;
        }
        if ((rootDirEnd = location.lastIndexOf(47, patternStart)) == -1) {
            rootDirEnd = location.lastIndexOf(":", patternStart) + 1;
        }
        return rootDirEnd != -1 ? location.substring(0, rootDirEnd) : "";
    }

    protected List doFindPathMatchingJarResources(Resource rootDirResource, String subPattern) throws IOException {
        URLConnection con = rootDirResource.getURL().openConnection();
        if (!(con instanceof JarURLConnection)) {
            throw new IOException("Cannot perform jar file search for [" + rootDirResource + "]: did not return java.net.JarURLConnection; connection was [" + con + "]");
        }
        JarURLConnection jarCon = (JarURLConnection)con;
        JarFile jarFile = jarCon.getJarFile();
        URL jarFileUrl = jarCon.getJarFileURL();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for matching resources in jar file [" + jarFileUrl + "]"));
        }
        String rootEntryPath = jarCon.getJarEntry().getName();
        String jarFileUrlPrefix = "jar:" + jarFileUrl.toExternalForm() + "!/";
        LinkedList<UrlResource> result = new LinkedList<UrlResource>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(rootEntryPath) || !PathMatcher.match(subPattern, entryPath.substring(rootEntryPath.length()))) continue;
            result.add(new UrlResource(new URL(jarFileUrlPrefix + entryPath)));
        }
        return result;
    }

    protected List doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        File rootDir = rootDirResource.getFile().getAbsoluteFile();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for matching resources in directory tree [" + rootDir.getPath() + "]"));
        }
        List matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        ArrayList<FileSystemResource> result = new ArrayList<FileSystemResource>(matchingFiles.size());
        Iterator it = matchingFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            result.add(new FileSystemResource(file));
        }
        return result;
    }

    protected List retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("'rootDir' parameter [" + rootDir + "] does not denote a directory");
        }
        String fullPattern = StringUtils.replace(rootDir.getAbsolutePath(), File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + StringUtils.replace(pattern, File.separator, "/");
        LinkedList result = new LinkedList();
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, List result) throws IOException {
        File[] dirContents;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching directory [" + dir.getAbsolutePath() + "] for files matching pattern [" + fullPattern + "]"));
        }
        if ((dirContents = dir.listFiles()) == null) {
            throw new IOException("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]");
        }
        boolean dirDepthNotFixed = fullPattern.indexOf("**") != -1;
        for (int i = 0; i < dirContents.length; ++i) {
            String currPath = StringUtils.replace(dirContents[i].getAbsolutePath(), File.separator, "/");
            if (dirContents[i].isDirectory() && (dirDepthNotFixed || StringUtils.countOccurrencesOf(currPath, "/") < StringUtils.countOccurrencesOf(fullPattern, "/"))) {
                this.doRetrieveMatchingFiles(fullPattern, dirContents[i], result);
            }
            if (!PathMatcher.match(fullPattern, currPath)) continue;
            result.add(dirContents[i]);
        }
    }
}

