/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;

public class CustomNumberEditor
extends PropertyEditorSupport {
    private Class numberClass;
    private NumberFormat numberFormat;
    private final boolean allowEmpty;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public CustomNumberEditor(Class numberClass, NumberFormat numberFormat, boolean allowEmpty) throws IllegalArgumentException {
        if (!(class$java$lang$Number == null ? (class$java$lang$Number = CustomNumberEditor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(numberClass)) {
            throw new IllegalArgumentException("Property class must be a subclass of Number");
        }
        this.numberClass = numberClass;
        this.numberFormat = numberFormat;
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        block12: {
            if (this.allowEmpty && text.trim().equals("")) {
                this.setValue(null);
            } else {
                try {
                    Number number = this.numberFormat.parse(text);
                    if (this.numberClass.isInstance(number)) {
                        this.setValue(number);
                        break block12;
                    }
                    if (this.numberClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = CustomNumberEditor.class$("java.lang.Short")) : class$java$lang$Short)) {
                        this.setValue(new Short(number.shortValue()));
                        break block12;
                    }
                    if (this.numberClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = CustomNumberEditor.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        this.setValue(new Integer(number.intValue()));
                        break block12;
                    }
                    if (this.numberClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = CustomNumberEditor.class$("java.lang.Long")) : class$java$lang$Long)) {
                        this.setValue(new Long(number.longValue()));
                        break block12;
                    }
                    if (this.numberClass.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = CustomNumberEditor.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                        this.setValue(BigInteger.valueOf(number.longValue()));
                        break block12;
                    }
                    if (this.numberClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = CustomNumberEditor.class$("java.lang.Float")) : class$java$lang$Float)) {
                        this.setValue(new Float(number.floatValue()));
                        break block12;
                    }
                    if (this.numberClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = CustomNumberEditor.class$("java.lang.Double")) : class$java$lang$Double)) {
                        this.setValue(new Double(number.doubleValue()));
                        break block12;
                    }
                    if (this.numberClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CustomNumberEditor.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                        this.setValue(new BigDecimal(Double.toString(number.doubleValue())));
                        break block12;
                    }
                    throw new IllegalArgumentException("Cannot convert [" + text + "] to [" + this.numberClass + "]");
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException("Cannot parse number: " + ex.getMessage());
                }
            }
        }
    }

    public String getAsText() {
        return this.numberFormat.format(this.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

