/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.UrlResource;

public class ResourceEditor
extends PropertyEditorSupport {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    public static final String CLASSPATH_URL_PREFIX = "classpath:";

    public void setAsText(String text) throws IllegalArgumentException {
        String resolvedPath = this.resolvePath(text);
        if (resolvedPath.startsWith(CLASSPATH_URL_PREFIX)) {
            this.setValue(new ClassPathResource(resolvedPath.substring(CLASSPATH_URL_PREFIX.length())));
        }
        try {
            URL url = new URL(resolvedPath);
            this.setValue(new UrlResource(url));
        }
        catch (MalformedURLException ex) {
            this.setValue(new ClassPathResource(text));
        }
    }

    protected String resolvePath(String path) {
        int endIndex;
        int startIndex = path.indexOf(PLACEHOLDER_PREFIX);
        if (startIndex != -1 && (endIndex = path.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length())) != -1) {
            String placeholder = path.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
            String propVal = System.getProperty(placeholder);
            if (propVal == null) {
                throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in file path [" + path + "] as system property");
            }
            return path.substring(0, startIndex) + propVal + path.substring(endIndex + 1);
        }
        return path;
    }
}

