/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;

public class ClassPathResource
extends AbstractResource {
    private final String path;
    private Class clazz;

    public ClassPathResource(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
    }

    public ClassPathResource(String path, Class clazz) {
        this.path = path;
        this.clazz = clazz;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        if (this.clazz != null) {
            is = this.clazz.getResourceAsStream(this.path);
        } else {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            is = ccl.getResourceAsStream(this.path);
        }
        if (is == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return is;
    }

    public String getDescription() {
        return "classpath resource [" + this.path + "]";
    }
}

