/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;

public class RootBeanDefinition
extends AbstractBeanDefinition {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    public static final int AUTOWIRE_CONSTRUCTOR = 3;
    public static final int AUTOWIRE_AUTODETECT = 4;
    public static final int DEPENDENCY_CHECK_NONE = 0;
    public static final int DEPENDENCY_CHECK_OBJECTS = 1;
    public static final int DEPENDENCY_CHECK_SIMPLE = 2;
    public static final int DEPENDENCY_CHECK_ALL = 3;
    private Object beanClass;
    private ConstructorArgumentValues constructorArgumentValues;
    private int autowireMode = 0;
    private int dependencyCheck = 0;
    private String[] dependsOn;
    private String initMethodName;
    private String destroyMethodName;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public RootBeanDefinition(Class beanClass, int autowireMode) {
        super(null);
        this.beanClass = beanClass;
        this.setAutowireMode(autowireMode);
    }

    public RootBeanDefinition(Class beanClass, int autowireMode, boolean dependencyCheck) {
        super(null);
        this.beanClass = beanClass;
        this.setAutowireMode(autowireMode);
        if (dependencyCheck && this.getResolvedAutowireMode() != 3) {
            this.setDependencyCheck(1);
        }
    }

    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs) {
        super(pvs);
        this.beanClass = beanClass;
    }

    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs, boolean singleton) {
        super(pvs);
        this.beanClass = beanClass;
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(pvs);
        this.beanClass = beanClass;
        this.constructorArgumentValues = cargs;
    }

    public RootBeanDefinition(String beanClassName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(pvs);
        this.beanClass = beanClassName;
        this.constructorArgumentValues = cargs;
    }

    public RootBeanDefinition(RootBeanDefinition other) {
        super(new MutablePropertyValues(other.getPropertyValues()));
        this.beanClass = other.beanClass;
        this.constructorArgumentValues = other.constructorArgumentValues;
        this.setSingleton(other.isSingleton());
        this.setLazyInit(other.isLazyInit());
        this.setDependsOn(other.getDependsOn());
        this.setDependencyCheck(other.getDependencyCheck());
        this.setAutowireMode(other.getAutowireMode());
        this.setInitMethodName(other.getInitMethodName());
        this.setDestroyMethodName(other.getDestroyMethodName());
    }

    public final Class getBeanClass() throws IllegalStateException {
        if (!(this.beanClass instanceof Class)) {
            throw new IllegalStateException("Bean definition does not carry a resolved bean class");
        }
        return (Class)this.beanClass;
    }

    public final String getBeanClassName() {
        if (this.beanClass instanceof Class) {
            return ((Class)this.beanClass).getName();
        }
        return (String)this.beanClass;
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.constructorArgumentValues;
    }

    public boolean hasConstructorArgumentValues() {
        return this.constructorArgumentValues != null && !this.constructorArgumentValues.isEmpty();
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public int getResolvedAutowireMode() {
        if (this.autowireMode == 4) {
            Constructor<?>[] constructors = this.getBeanClass().getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length != 0) continue;
                return 2;
            }
            return 3;
        }
        return this.autowireMode;
    }

    public void setDependencyCheck(int dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public int getDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependsOn(String[] dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public void setInitMethodName(String initMethodName) {
        this.initMethodName = initMethodName;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setDestroyMethodName(String destroyMethodName) {
        this.destroyMethodName = destroyMethodName;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void validate() throws BeanDefinitionValidationException {
        super.validate();
        if (this.beanClass == null) {
            throw new BeanDefinitionValidationException("beanClass must be set in RootBeanDefinition");
        }
        if (this.beanClass instanceof Class) {
            if ((class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = RootBeanDefinition.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(this.getBeanClass()) && !this.isSingleton()) {
                throw new BeanDefinitionValidationException("FactoryBean must be defined as singleton - FactoryBeans themselves are not allowed to be prototypes");
            }
            if (this.getBeanClass().getConstructors().length == 0) {
                throw new BeanDefinitionValidationException("No public constructor in class [" + this.getBeanClass() + "]");
            }
        }
    }

    public String toString() {
        return "Root bean with class [" + this.getBeanClassName() + "] defined in " + this.getResourceDescription();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

