/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.config.RuntimeBeanReference;

public class PropertyPlaceholderConfigurer
extends PropertyResourceConfigurer {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private boolean checkSystemProperties = true;

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setCheckSystemProperties(boolean checkSystemProperties) {
        this.checkSystemProperties = checkSystemProperties;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            ConstructorArgumentValues cas;
            MutablePropertyValues pvs = beanFactory.getPropertyValues(beanNames[i]);
            if (pvs != null) {
                this.parsePropertyValues(props, pvs);
            }
            if ((cas = beanFactory.getConstructorArgumentValues(beanNames[i])) == null) continue;
            this.parseIndexedArgumentValues(props, cas.getIndexedArgumentValues());
            this.parseGenericArgumentValues(props, cas.getGenericArgumentValues());
        }
    }

    protected void parsePropertyValues(Properties props, MutablePropertyValues pvs) {
        for (int j = 0; j < pvs.getPropertyValues().length; ++j) {
            PropertyValue pv = pvs.getPropertyValues()[j];
            if (pv.getValue() instanceof String) {
                String strVal = (String)pv.getValue();
                String newStrVal = this.parseValue(props, strVal, null);
                if (newStrVal.equals(strVal)) continue;
                pvs.addPropertyValue(pv.getName(), newStrVal);
                continue;
            }
            if (pv.getValue() instanceof RuntimeBeanReference) {
                RuntimeBeanReference ref = (RuntimeBeanReference)pv.getValue();
                String newBeanName = this.parseValue(props, ref.getBeanName(), null);
                if (newBeanName.equals(ref.getBeanName())) continue;
                RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
                pvs.addPropertyValue(pv.getName(), newRef);
                continue;
            }
            if (pv.getValue() instanceof List) {
                this.parseList(props, (List)pv.getValue());
                continue;
            }
            if (!(pv.getValue() instanceof Map)) continue;
            this.parseMap(props, (Map)pv.getValue());
        }
    }

    protected void parseIndexedArgumentValues(Properties props, Map ias) {
        Iterator it = ias.keySet().iterator();
        while (it.hasNext()) {
            Integer index = (Integer)it.next();
            Object val = ias.get(index);
            if (val instanceof String) {
                String strVal = (String)val;
                String newStrVal = this.parseValue(props, strVal, null);
                if (newStrVal.equals(strVal)) continue;
                ias.put(index, newStrVal);
                continue;
            }
            if (val instanceof RuntimeBeanReference) {
                RuntimeBeanReference ref = (RuntimeBeanReference)val;
                String newBeanName = this.parseValue(props, ref.getBeanName(), null);
                if (newBeanName.equals(ref.getBeanName())) continue;
                RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
                ias.put(index, newRef);
                continue;
            }
            if (val instanceof List) {
                this.parseList(props, (List)val);
                continue;
            }
            if (!(val instanceof Map)) continue;
            this.parseMap(props, (Map)val);
        }
    }

    protected void parseGenericArgumentValues(Properties props, Set gas) {
        Iterator it = gas.iterator();
        while (it.hasNext()) {
            Object val = it.next();
            if (val instanceof String) {
                String strVal = (String)val;
                String newStrVal = this.parseValue(props, strVal, null);
                if (newStrVal.equals(strVal)) continue;
                gas.remove(val);
                gas.add(newStrVal);
                continue;
            }
            if (val instanceof RuntimeBeanReference) {
                RuntimeBeanReference ref = (RuntimeBeanReference)val;
                String newBeanName = this.parseValue(props, ref.getBeanName(), null);
                if (newBeanName.equals(ref.getBeanName())) continue;
                RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
                gas.remove(val);
                gas.add(newRef);
                continue;
            }
            if (val instanceof List) {
                this.parseList(props, (List)val);
                continue;
            }
            if (!(val instanceof Map)) continue;
            this.parseMap(props, (Map)val);
        }
    }

    protected void parseList(Properties props, List listVal) {
        for (int k = 0; k < listVal.size(); ++k) {
            RuntimeBeanReference ref;
            String newBeanName;
            Object elem = listVal.get(k);
            if (elem instanceof String) {
                String strVal = (String)elem;
                String newStrVal = this.parseValue(props, strVal, null);
                if (newStrVal.equals(strVal)) continue;
                listVal.set(k, newStrVal);
                continue;
            }
            if (!(elem instanceof RuntimeBeanReference) || (newBeanName = this.parseValue(props, (ref = (RuntimeBeanReference)elem).getBeanName(), null)).equals(ref.getBeanName())) continue;
            RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
            listVal.set(k, newRef);
        }
    }

    protected void parseMap(Properties props, Map mapVal) {
        Iterator it = new HashMap(mapVal).keySet().iterator();
        while (it.hasNext()) {
            RuntimeBeanReference ref;
            String newBeanName;
            Object key = it.next();
            Object elem = mapVal.get(key);
            if (elem instanceof String) {
                String strVal = (String)elem;
                String newStrVal = this.parseValue(props, strVal, null);
                if (newStrVal.equals(strVal)) continue;
                mapVal.put(key, newStrVal);
                continue;
            }
            if (!(elem instanceof RuntimeBeanReference) || (newBeanName = this.parseValue(props, (ref = (RuntimeBeanReference)elem).getBeanName(), null)).equals(ref.getBeanName())) continue;
            RuntimeBeanReference newRef = new RuntimeBeanReference(newBeanName);
            mapVal.put(key, newRef);
        }
    }

    protected String parseValue(Properties props, String strVal, String originalPlaceholder) throws BeansException {
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = strVal.indexOf(this.placeholderSuffix, startIndex + this.placeholderPrefix.length());
            if (endIndex != -1) {
                String placeholder = strVal.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                if (originalPlaceholder == null) {
                    originalPlaceholder = placeholder;
                } else if (placeholder.equals(originalPlaceholder)) {
                    throw new BeanDefinitionStoreException("Circular placeholder reference '" + placeholder + "' in property definitions [" + props + "]");
                }
                String propVal = props.getProperty(placeholder);
                if (propVal == null && this.checkSystemProperties) {
                    propVal = System.getProperty(placeholder);
                }
                if (propVal != null) {
                    propVal = this.parseValue(props, propVal, originalPlaceholder);
                    this.logger.debug((Object)("Resolving placeholder '" + placeholder + "' to [" + propVal + "]"));
                    strVal = strVal.substring(0, startIndex) + propVal + strVal.substring(endIndex + 1);
                    startIndex = strVal.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                    continue;
                }
                throw new BeanDefinitionStoreException("Could not resolve placeholder '" + placeholder + "'");
            }
            startIndex = -1;
        }
        return strVal;
    }
}

