/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class MethodInvokingFactoryBean
implements FactoryBean,
InitializingBean {
    public static final VoidType VOID = new VoidType();
    private boolean _singleton = true;
    private String _staticMethod;
    private Object _target;
    private String _targetMethod;
    private Object[] _args;
    private Object _singletonObj;
    private Method _methodObj;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$MethodInvokingFactoryBean$VoidType;

    public Object getObject() throws Exception {
        if (this._singleton) {
            if (this._singletonObj == null) {
                this._singletonObj = this.obtainObject();
            }
            return this._singletonObj;
        }
        return this.obtainObject();
    }

    public Class getObjectType() {
        Class type = this._methodObj.getReturnType();
        if (type.equals(Void.TYPE)) {
            type = class$org$springframework$beans$factory$config$MethodInvokingFactoryBean$VoidType == null ? (class$org$springframework$beans$factory$config$MethodInvokingFactoryBean$VoidType = MethodInvokingFactoryBean.class$("org.springframework.beans.factory.config.MethodInvokingFactoryBean$VoidType")) : class$org$springframework$beans$factory$config$MethodInvokingFactoryBean$VoidType;
        }
        return type;
    }

    public boolean isSingleton() {
        return this._singleton;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, BeansException {
        if (this._args == null) {
            this._args = new Object[0];
        }
        Class[] types = new Class[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            types[i] = this._args[i].getClass();
        }
        if (this._target == null && this._staticMethod == null || this._target != null && this._staticMethod != null) {
            throw new IllegalArgumentException("At least one, and one only of target or staticMethod must be set.");
        }
        try {
            block13: {
                Class<?> targetClass;
                String methodName;
                if (this._staticMethod != null) {
                    String invalid = "Invalid fully qualified static method name: ";
                    int index = this._staticMethod.lastIndexOf(46);
                    if (index == -1) {
                        throw new IllegalArgumentException(invalid + this._staticMethod);
                    }
                    methodName = this._staticMethod.substring(index + 1);
                    String fqClassname = this._staticMethod.substring(0, index);
                    targetClass = Thread.currentThread().getContextClassLoader().loadClass(fqClassname);
                } else {
                    if (this._targetMethod == null) {
                        throw new IllegalArgumentException("targetMethod must be set when target is set.");
                    }
                    targetClass = this._target.getClass();
                    methodName = this._targetMethod;
                }
                try {
                    this._methodObj = targetClass.getMethod(methodName, types);
                }
                catch (NoSuchMethodException e) {
                    int matches = 0;
                    Method[] methods = targetClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        Method method = methods[i];
                        if (!method.getName().equals(methodName) || method.getParameterTypes().length != types.length) continue;
                        this._methodObj = method;
                        ++matches;
                    }
                    if (this._methodObj != null && matches <= true) break block13;
                    throw e;
                }
            }
            if (this._staticMethod != null && !Modifier.isStatic(this._methodObj.getModifiers())) {
                throw new IllegalArgumentException("target method should be static but is not");
            }
        }
        catch (Exception e) {
            throw new FatalBeanException("Unable to obtain target method object", e);
        }
    }

    public void setSingleton(boolean singleton) {
        this._singleton = singleton;
    }

    public String getStaticMethod() {
        return this._staticMethod;
    }

    public void setStaticMethod(String staticMethod) {
        this._staticMethod = staticMethod;
    }

    public Object getTarget() {
        return this._target;
    }

    public void setTarget(Object target) {
        this._target = target;
    }

    public String getTargetMethod() {
        return this._targetMethod;
    }

    public void setTargetMethod(String targetMethod) {
        this._targetMethod = targetMethod;
    }

    public Object[] getArgs() {
        return this._args;
    }

    public void setArgs(Object[] args) {
        this._args = args;
    }

    private Object obtainObject() throws Exception {
        Object result = this._methodObj.invoke(this._target, this._args);
        if (result == null) {
            result = VOID;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class VoidType {
    }
}

